/*
 * #%L
 * bow
 * 
 * $Id: DeleteSearchResultsAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/bookmark/DeleteSearchResultsAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.bookmark;

import org.apache.commons.lang.StringUtils;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;

import java.util.List;

/**
 * Supprime des bookmarks qui satisfont le critere de recherche.
 *
 * @author poussin
 */
public class DeleteSearchResultsAction extends BowBaseAction {

    private static final long serialVersionUID = -3903724044644625507L;

    /** Deletes the search results */
    public String execute() {
        try {
            if (StringUtils.isNotBlank(tagLine)
                || StringUtils.isNotBlank(fullTextLine)) {
                BowUser user = getBowSession().getUser();
                // FIXME poussin 20110817 ATTENTION, la recherche remonte
                // potentiellement des bookmarks qui ne nous appartiennent pas,
                // dans ce cas, ne faudrait-il pas seulement ce supprimer des
                // reader/write/admin ?
                // FIXME tchemit 20110829 J'ai mis en dernier paramètre 0 car ça ne compilait pô mais je sais pas si c'est le bon!...
                Criteria criteria = BookmarkUtils.getBookmarkListCriteriaByUser(
                        user, tagLine, fullTextLine, null, 0);

                WikittyProxy proxy = getBowProxy();
                List<String> ids = proxy.findAllIdByCriteria(criteria).getAll();

                if (log.isDebugEnabled()) {
                    log.debug("Will delete " + ids.size() + " bookmarks");
                }

                proxy.delete(ids);
                addActionMessage(_("bow.search.results.deleted"));
            }
        } catch (Exception eee) {
            addActionError(_("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        return SUCCESS;
    }
}