/*
 * #%L
 * bow
 * 
 * $Id: AddOrUpdateAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/bookmark/AddOrUpdateAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.bookmark;

import org.apache.commons.lang.StringUtils;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

/**
 * Ajoute ou modifie un bookmark, soit par le formulaire,
 * soit par un appel javascript
 *
 * @author poussin
 */
public class AddOrUpdateAction extends BowBaseAction {

    private static final long serialVersionUID = 3389170166034184139L;

    protected String bookmarkId;

    protected String link;

    protected String name;

    protected String privateAlias;

    protected String publicAlias;

    protected String tags;

    protected String nameAndTags;

    protected String redirectTo;

    public String getBookmarkId() {
        return bookmarkId;
    }

    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    /** @return the link */
    public String getLink() {
        return link;
    }

    /** @param link the link to set */
    public void setLink(String link) {
        this.link = link;
    }

    /** @return the description */
    public String getName() {
        return name;
    }

    /** @param name the description to set */
    public void setName(String name) {
        this.name = name;
    }

    /** @return the privateAlias */
    public String getPrivateAlias() {
        return privateAlias;
    }

    /** @param privateAlias the privateAlias to set */
    public void setPrivateAlias(String privateAlias) {
        this.privateAlias = privateAlias;
    }

    public String getPublicAlias() {
        return publicAlias;
    }

    public void setPublicAlias(String publicAlias) {
        this.publicAlias = publicAlias;
    }

    /** @return the tags */
    public String getTags() {
        return tags;
    }

    /** @param tags the tags to set */
    public void setTags(String tags) {
        this.tags = tags;
    }

    /** @return the nameAndTags */
    public String getNameAndTags() {
        return nameAndTags;
    }

    /** @param nameAndTags the nameAndTags to set */
    public void setNameAndTags(String nameAndTags) {
        this.nameAndTags = nameAndTags;
    }

    /** @return the redirectTo */
    public String getRedirectTo() {
        return redirectTo;
    }

    @Override
    public String execute() {
        String result = SUCCESS;
        try {
            WikittyProxy proxy = getBowProxy();
            BowBookmark bookmark = null;
            BowBookmark bookmarkToModify = null;

            BowUser user = getBowSession().getUser();
            String userId = user.getWikittyId();
            if (StringUtils.isNotBlank(bookmarkId)) {
                bookmarkToModify = proxy.restore(BowBookmark.class, bookmarkId);
            }
            if (log.isDebugEnabled()) {
                log.debug("Change old wikitty: " + bookmarkToModify);
            }

            // gere le cas d'une mise a jour ou d'un ajout via le formulaire
            if (name != null) {
                // Si l'alias prive souhaite est deja utilise on ne l'accept pas
                // Si l'alias public souhaite est deja utilise on ne l'accept pas
                // TODO sletellier 20110416 : return error message when public or private alias is already used
                Criteria privateAliasCriteria = null;
                Criteria publicAliasCriteria = null;
                if (StringUtils.isNotEmpty(privateAlias)) {
                    privateAliasCriteria = Search.query()
                            .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_PRIVATEALIAS, privateAlias)
                            .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, userId)
                            .criteria().setEndIndex(0);
                }
                if (StringUtils.isNotEmpty(publicAlias)) {
                    publicAliasCriteria = Search.query()
                            .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_PUBLICALIAS, publicAlias)
                            .criteria().setEndIndex(0);
                }
                PagedResult<String>[] aliasResult = proxy.findAllIdByCriteria(
                        privateAliasCriteria, publicAliasCriteria);

                if (aliasResult[0] != null && aliasResult[0].getNumFound() > 0) {
                    if (bookmarkToModify == null) {
                        privateAlias = "";
                    } else {
                        privateAlias = bookmarkToModify.getPrivateAlias();
                    }
                }
                if (aliasResult[1] != null && aliasResult[1].getNumFound() > 0) {
                    if (bookmarkToModify == null) {
                        publicAlias = "";
                    } else {
                        publicAlias = bookmarkToModify.getPublicAlias();
                    }
                }

                if (bookmarkToModify == null) {
                    bookmark = BookmarkUtils.createBookmark(
                            link, name, tags, user, privateAlias, publicAlias, null);
                } else {
                    BookmarkUtils.updateBookmark(
                            bookmarkToModify, name, link, tags, privateAlias, publicAlias);
                }
            } else { //This part is for the bookmark addition by script
                if (nameAndTags != null) {
                    bookmark = BookmarkUtils.createBookmark(link, nameAndTags, user);
                }
            }
            // si on a reussi a creer le bookmark, on regarde s'il ne faut pas 
            // le fusionner avec un deja existant
            if (bookmark != null && !bookmark.getDescription().isEmpty()
                && !bookmark.getOwner().isEmpty()) {

                // looking for already bookmark with same url, to fusion them
                String link = bookmark.getLink();
                Criteria criteria = Search.query()
                        .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_LINK, link)
                        .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, userId)
                        .criteria();
                BowBookmark oldBookmark =
                        proxy.findByCriteria(BowBookmark.class, criteria);
                if (oldBookmark != null) {
                    // fusionne les descriptions et les tags
                    // par contre on prend le dernier privateAlias prive choisi par 
                    // l'utilisateur s'il y en a un
                    String description = oldBookmark.getDescription();
                    if (!StringUtils.isEmpty(bookmark.getDescription())) {
                        description += "\n";
                        description += BowUtils.formatDate(
                                bookmark.getCreationDate()) + ": ";
                        description += bookmark.getDescription();
                    }

                    oldBookmark.setDescription(description);
                    oldBookmark.addAllLabels(bookmark.getLabels());
                    String privateAlias = bookmark.getPrivateAlias();
                    if (!StringUtils.isEmpty(privateAlias)) {
                        oldBookmark.setPrivateAlias(privateAlias);
                    }

                    bookmark = oldBookmark;
                }

            }

            if (bookmark != null || bookmarkToModify != null) {
                proxy.store(bookmark, bookmarkToModify); //Stores the bookmark if everything is ok
                addActionMessage(_("bow.bookmark.add.successful"));
                if (log.isDebugEnabled()) {
                    log.debug("Adding URL");
                }
            }
            redirectTo = BowUtils.redirectTo(tagLine, fullTextLine);
        } catch (Exception eee) {
            result = ERROR;
            addActionError(_("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        return result;
    }
}