/*
 * #%L
 * BOW UI
 * 
 * $Id: MigrateDataAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/admin/MigrateDataAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.admin;


import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowMigration04To05;
import org.chorem.bow.BowMigration06To11;
import org.chorem.bow.BowSession;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.util.VersionUtil;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Lance la migration des données de la version 0.4 vers 0.5
 *
 * @author poussin
 * @version $Revision: 324 $
 *          <p/>
 *          Last update: $Date: 2011-08-29 14:21:36 +0200 (Mon, 29 Aug 2011) $
 *          by : $Author: tchemit $
 */
public class MigrateDataAction extends BowBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(MigrateDataAction.class);

    /** Version must be real version, like 0.4, 0.5 or 0.6 */
    protected String versionFrom;

    protected String versionTo;

    public void setVersionFrom(String versionFrom) {
        this.versionFrom = versionFrom;
    }

    public void setVersionTo(String versionTo) {
        this.versionTo = versionTo;
    }

    @Override
    public String execute() {
        try {
            if (StringUtils.isBlank(versionFrom) || StringUtils.isBlank(versionTo)) {
                log.error("Migration action must have to parameter: versionFrom and versionTo");
            } else {
                BowSession session = getBowSession();
                if (session.isAdmin()) { //If is admin
                    WikittyProxy proxy = getBowProxy();

                    if (VersionUtil.equals(versionFrom, "0.4")
                        && VersionUtil.equals(versionTo, "0.5")) {
                        BowMigration04To05.migrate(proxy);
                        addActionMessage(_("bow.admin.dataMigration.success"));
                    } else if (VersionUtil.equals(versionFrom, "0.6")
                               && VersionUtil.equals(versionTo, "1.1")) {
                        BowMigration06To11.migrate(proxy);
                        addActionMessage(_("bow.admin.dataMigration.success"));
                    } else {
                        addActionMessage(String.format(
                                "No migration found for %s to %s",
                                versionFrom, versionTo));
                    }
                }
            }
        } catch (Exception eee) {
            addActionError(_("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        return SUCCESS;
    }

}
