package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class ImportAbstract extends BusinessEntityImpl implements Import {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionImport;
    /**
     * getDate :
     * @return Date 
     */

    @Override
    public Date getDate() {
        Date value = ImportHelper.getDate(getWikitty());
        return value;
}

    /**
     * setDate :
     * @param date 
     */

    @Override
    public void setDate(Date date) {
        Date oldValue = getDate();
        ImportHelper.setDate(getWikitty(), date);
        getPropertyChangeSupport().firePropertyChange(Import.FIELD_IMPORT_DATE, oldValue, getDate());
}

    /**
     * ImportAbstract :
     */

    public ImportAbstract() {
        super();
}

    /**
     * ImportAbstract :
     * @param wikitty 
     */

    public ImportAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * ImportAbstract :
     * @param businessEntityImpl 
     */

    public ImportAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionImport =
                new WikittyExtension(EXT_IMPORT,
                                     "1.0", // version
                                     (List)null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Date date unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionImport);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //ImportAbstract
