package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class BowUserAbstract extends BusinessEntityImpl implements BowUser {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionBowUser;
    /**
     * getPermanentToken :
     * @return String 
     */

    @Override
    public String getPermanentToken() {
        String value = BowUserHelper.getPermanentToken(getWikitty());
        return value;
}

    /**
     * setPermanentToken :
     * @param permanentToken 
     */

    @Override
    public void setPermanentToken(String permanentToken) {
        String oldValue = getPermanentToken();
        BowUserHelper.setPermanentToken(getWikitty(), permanentToken);
        getPropertyChangeSupport().firePropertyChange(BowUser.FIELD_BOWUSER_PERMANENTTOKEN, oldValue, getPermanentToken());
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        String value = WikittyUserHelper.getLogin(getWikitty());
        return value;
}

    /**
     * setLogin :
     * @param login 
     */

    public void setLogin(String login) {
        String oldValue = getLogin();
        WikittyUserHelper.setLogin(getWikitty(), login);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        String value = WikittyUserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    public void setPassword(String password) {
        String oldValue = getPassword();
        WikittyUserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    /**
     * getTags :
     * @return int 
     */

    public int getTags() {
        int value = BowPreferenceHelper.getTags(getWikitty());
        return value;
}

    /**
     * setTags :
     * @param tags 
     */

    public void setTags(int tags) {
        int oldValue = getTags();
        BowPreferenceHelper.setTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_TAGS, oldValue, getTags());
}

    /**
     * getBookmarks :
     * @return int 
     */

    public int getBookmarks() {
        int value = BowPreferenceHelper.getBookmarks(getWikitty());
        return value;
}

    /**
     * setBookmarks :
     * @param bookmarks 
     */

    public void setBookmarks(int bookmarks) {
        int oldValue = getBookmarks();
        BowPreferenceHelper.setBookmarks(getWikitty(), bookmarks);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS, oldValue, getBookmarks());
}

    /**
     * getColors :
     * @return String 
     */

    public String getColors() {
        String value = BowPreferenceHelper.getColors(getWikitty());
        return value;
}

    /**
     * setColors :
     * @param colors 
     */

    public void setColors(String colors) {
        String oldValue = getColors();
        BowPreferenceHelper.setColors(getWikitty(), colors);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_COLORS, oldValue, getColors());
}

    /**
     * getSearchEngineUrlSuggestions :
     * @return String 
     */

    public String getSearchEngineUrlSuggestions() {
        String value = BowPreferenceHelper.getSearchEngineUrlSuggestions(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlSuggestions :
     * @param searchEngineUrlSuggestions 
     */

    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        String oldValue = getSearchEngineUrlSuggestions();
        BowPreferenceHelper.setSearchEngineUrlSuggestions(getWikitty(), searchEngineUrlSuggestions);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLSUGGESTIONS, oldValue, getSearchEngineUrlSuggestions());
}

    /**
     * getSearchEngineUrlResults :
     * @return String 
     */

    public String getSearchEngineUrlResults() {
        String value = BowPreferenceHelper.getSearchEngineUrlResults(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlResults :
     * @param searchEngineUrlResults 
     */

    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        String oldValue = getSearchEngineUrlResults();
        BowPreferenceHelper.setSearchEngineUrlResults(getWikitty(), searchEngineUrlResults);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLRESULTS, oldValue, getSearchEngineUrlResults());
}

    /**
     * getDefaultAction :
     * @return String 
     */

    public String getDefaultAction() {
        String value = BowPreferenceHelper.getDefaultAction(getWikitty());
        return value;
}

    /**
     * setDefaultAction :
     * @param defaultAction 
     */

    public void setDefaultAction(String defaultAction) {
        String oldValue = getDefaultAction();
        BowPreferenceHelper.setDefaultAction(getWikitty(), defaultAction);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_DEFAULTACTION, oldValue, getDefaultAction());
}

    /**
     * getDefaultPrefix :
     * @return String 
     */

    public String getDefaultPrefix() {
        String value = BowPreferenceHelper.getDefaultPrefix(getWikitty());
        return value;
}

    /**
     * setDefaultPrefix :
     * @param defaultPrefix 
     */

    public void setDefaultPrefix(String defaultPrefix) {
        String oldValue = getDefaultPrefix();
        BowPreferenceHelper.setDefaultPrefix(getWikitty(), defaultPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_DEFAULTPREFIX, oldValue, getDefaultPrefix());
}

    /**
     * getTagSearchPrefix :
     * @return String 
     */

    public String getTagSearchPrefix() {
        String value = BowPreferenceHelper.getTagSearchPrefix(getWikitty());
        return value;
}

    /**
     * setTagSearchPrefix :
     * @param tagSearchPrefix 
     */

    public void setTagSearchPrefix(String tagSearchPrefix) {
        String oldValue = getTagSearchPrefix();
        BowPreferenceHelper.setTagSearchPrefix(getWikitty(), tagSearchPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_TAGSEARCHPREFIX, oldValue, getTagSearchPrefix());
}

    /**
     * getFullTextSearchPrefix :
     * @return String 
     */

    public String getFullTextSearchPrefix() {
        String value = BowPreferenceHelper.getFullTextSearchPrefix(getWikitty());
        return value;
}

    /**
     * setFullTextSearchPrefix :
     * @param fullTextSearchPrefix 
     */

    public void setFullTextSearchPrefix(String fullTextSearchPrefix) {
        String oldValue = getFullTextSearchPrefix();
        BowPreferenceHelper.setFullTextSearchPrefix(getWikitty(), fullTextSearchPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_FULLTEXTSEARCHPREFIX, oldValue, getFullTextSearchPrefix());
}

    /**
     * getWebSearchPrefix :
     * @return String 
     */

    public String getWebSearchPrefix() {
        String value = BowPreferenceHelper.getWebSearchPrefix(getWikitty());
        return value;
}

    /**
     * setWebSearchPrefix :
     * @param webSearchPrefix 
     */

    public void setWebSearchPrefix(String webSearchPrefix) {
        String oldValue = getWebSearchPrefix();
        BowPreferenceHelper.setWebSearchPrefix(getWikitty(), webSearchPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_WEBSEARCHPREFIX, oldValue, getWebSearchPrefix());
}

    /**
     * getAliasPrefix :
     * @return String 
     */

    public String getAliasPrefix() {
        String value = BowPreferenceHelper.getAliasPrefix(getWikitty());
        return value;
}

    /**
     * setAliasPrefix :
     * @param aliasPrefix 
     */

    public void setAliasPrefix(String aliasPrefix) {
        String oldValue = getAliasPrefix();
        BowPreferenceHelper.setAliasPrefix(getWikitty(), aliasPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_ALIASPREFIX, oldValue, getAliasPrefix());
}

    /**
     * getPrefixSeparator :
     * @return String 
     */

    public String getPrefixSeparator() {
        String value = BowPreferenceHelper.getPrefixSeparator(getWikitty());
        return value;
}

    /**
     * setPrefixSeparator :
     * @param prefixSeparator 
     */

    public void setPrefixSeparator(String prefixSeparator) {
        String oldValue = getPrefixSeparator();
        BowPreferenceHelper.setPrefixSeparator(getWikitty(), prefixSeparator);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_PREFIXSEPARATOR, oldValue, getPrefixSeparator());
}

    /**
     * BowUserAbstract :
     */

    public BowUserAbstract() {
        super();
}

    /**
     * BowUserAbstract :
     * @param wikitty 
     */

    public BowUserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * BowUserAbstract :
     * @param businessEntityImpl 
     */

    public BowUserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionBowUser =
                new WikittyExtension(EXT_BOWUSER,
                                     "2.0", // version
                                     WikittyUser.EXT_WIKITTYUSER + "," + BowPreference.EXT_BOWPREFERENCE,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String permanentToken unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyUserAbstract.extensions); 
        // current after requires ones

        exts.addAll(BowPreferenceAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBowUser);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //BowUserAbstract
