package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public interface BowUser extends BusinessEntity, WikittyUser, BowPreference {     String EXT_BOWUSER = "BowUser";
     String FIELD_BOWUSER_PERMANENTTOKEN = "permanentToken";
     String FQ_FIELD_BOWUSER_PERMANENTTOKEN = EXT_BOWUSER + ".permanentToken";
    /**
     * getPermanentToken :
     * @return String 
     */

     String getPermanentToken();

    /**
     * setPermanentToken :
     * @param permanentToken 
     */

     void setPermanentToken(String permanentToken);

    /**
     * getLogin :
     * @return String 
     */

     String getLogin();

    /**
     * setLogin :
     * @param login 
     */

     void setLogin(String login);

    /**
     * getPassword :
     * @return String 
     */

     String getPassword();

    /**
     * setPassword :
     * @param password 
     */

     void setPassword(String password);

    /**
     * getTags :
     * @return int 
     */

     int getTags();

    /**
     * setTags :
     * @param tags 
     */

     void setTags(int tags);

    /**
     * getBookmarks :
     * @return int 
     */

     int getBookmarks();

    /**
     * setBookmarks :
     * @param bookmarks 
     */

     void setBookmarks(int bookmarks);

    /**
     * getColors :
     * @return String 
     */

     String getColors();

    /**
     * setColors :
     * @param colors 
     */

     void setColors(String colors);

    /**
     * getSearchEngineUrlSuggestions :
     * @return String 
     */

     String getSearchEngineUrlSuggestions();

    /**
     * setSearchEngineUrlSuggestions :
     * @param searchEngineUrlSuggestions 
     */

     void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions);

    /**
     * getSearchEngineUrlResults :
     * @return String 
     */

     String getSearchEngineUrlResults();

    /**
     * setSearchEngineUrlResults :
     * @param searchEngineUrlResults 
     */

     void setSearchEngineUrlResults(String searchEngineUrlResults);

    /**
     * getDefaultAction :
     * Indique l'action par defaut a faire, si l'utilisateur n'indique ni prefix ni separateur de prefix
     * @return String 
     */

     String getDefaultAction();

    /**
     * setDefaultAction :
     * @param defaultAction 
     */

     void setDefaultAction(String defaultAction);

    /**
     * getDefaultPrefix :
     * Retourne le prefix par defaut a utiliser si l'utilisateur a mis le separateur de prefix mais sans prefix
     * @return String 
     */

     String getDefaultPrefix();

    /**
     * setDefaultPrefix :
     * @param defaultPrefix 
     */

     void setDefaultPrefix(String defaultPrefix);

    /**
     * getTagSearchPrefix :
     * le prefix pour indiquer que l'on souhaite une recherche sur les tags
     * @return String 
     */

     String getTagSearchPrefix();

    /**
     * setTagSearchPrefix :
     * @param tagSearchPrefix 
     */

     void setTagSearchPrefix(String tagSearchPrefix);

    /**
     * getFullTextSearchPrefix :
     * le prefix pour indiquer que l'on souhaite une recherche sur fulltext dans bow
     * @return String 
     */

     String getFullTextSearchPrefix();

    /**
     * setFullTextSearchPrefix :
     * @param fullTextSearchPrefix 
     */

     void setFullTextSearchPrefix(String fullTextSearchPrefix);

    /**
     * getWebSearchPrefix :
     * le prefix pour indiquer que l'on souhaite une recherche sur le web via le moteur de recherche configurer
     * @return String 
     */

     String getWebSearchPrefix();

    /**
     * setWebSearchPrefix :
     * @param webSearchPrefix 
     */

     void setWebSearchPrefix(String webSearchPrefix);

    /**
     * getAliasPrefix :
     * le prefix pour indiquer que l'on souhaite une recherche sur les alias prive et une rediection automatique vers cette page
     * @return String 
     */

     String getAliasPrefix();

    /**
     * setAliasPrefix :
     * @param aliasPrefix 
     */

     void setAliasPrefix(String aliasPrefix);

    /**
     * getPrefixSeparator :
     * Retourne le separateur choisi par l'utilisateur entre les prefix d'action et la chaine
     * @return String 
     */

     String getPrefixSeparator();

    /**
     * setPrefixSeparator :
     * @param prefixSeparator 
     */

     void setPrefixSeparator(String prefixSeparator);


} //BowUser
