/*
 * #%L
 * bow
 * 
 * $Id: BowSession.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/BowSession.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Map;

/**
 * Classe utilisee pour stocker les objets utils en session utilisateur
 *
 * @author poussin
 * @version $Revision: 324 $
 *          <p/>
 *          Last update: $Date: 2011-08-29 14:21:36 +0200 (Mon, 29 Aug 2011) $
 *          by : $Author: tchemit $
 */
public class BowSession implements Serializable {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(BowSession.class);

    static final private String BOW_SESSION_KEY = BowSession.class.getSimpleName();

    private static final long serialVersionUID = 1L;

    protected BowProxy proxy;

    // user herite de preference, on ne stocke que user
    protected BowUser user;

    protected String temporaryToken;

    protected boolean admin;

    public BowSession() {
        proxy = BowProxy.getInstance(null);
    }

    public static void invalidate(Map<String, Object> session) {
        session.remove(BOW_SESSION_KEY);
    }

    public static BowSession getBowSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        BowSession result = getBowSession(session);
        return result;
    }

    public static BowSession getBowSession(HttpSession httpSession) {
        BowSession result = (BowSession) httpSession.getAttribute(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            httpSession.setAttribute(BOW_SESSION_KEY, result);
        }
        return result;
    }

    public static BowSession getBowSession(Map<String, Object> session) {
        BowSession result = (BowSession) session.get(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            session.put(BOW_SESSION_KEY, result);
        }
        return result;
    }

    public BowProxy getProxy() {
        return proxy;
    }

    public BowUser getUser() {
        return user;
    }

    public void setUser(BowUser user) {
        // check if this user is admin
        String login = user.getLogin();
        String[] admins = BowConfig.getAdmins();
        boolean isAdmin = ArrayUtils.contains(admins, login);
        setAdmin(isAdmin);

        checkPreference(user);

        // si c'est le meme user, on ne regenere pas le temporaryToken
        if (!ObjectUtils.equals(this.user, user)) {
            // generate temporary token
            String temporaryToken = BowUtils.generateToken();
            setTemporaryToken(temporaryToken);
        }
        this.user = user;
    }

    protected void checkPreference(BowPreference preference) {
        if (preference.getBookmarks() <= 0) {
            preference.setBookmarks(100); // set default to 100
        }
        if (preference.getTags() <= 0) {
            preference.setTags(100); // set default to 100
        }
        if (preference.getColors() == null) {
            preference.setColors("");
        }
        if (preference.getSearchEngineUrlResults() == null) {
            preference.setSearchEngineUrlResults(BowConfig.getSearchEngine());
        }
        if (preference.getSearchEngineUrlSuggestions() == null) {
            preference.setSearchEngineUrlSuggestions(""); // TODO add default value in config
        }
        if (StringUtils.isBlank(preference.getPrefixSeparator())) {
            preference.setPrefixSeparator(BowConfig.getPrefixSeparator());
        }
        if (StringUtils.isBlank(preference.getTagSearchPrefix())) {
            preference.setTagSearchPrefix(BowConfig.getTagSearchPrefix());
        }
        if (StringUtils.isBlank(preference.getFullTextSearchPrefix())) {
            preference.setFullTextSearchPrefix(BowConfig.getFullTextSearchPrefix());
        }
        if (StringUtils.isBlank(preference.getWebSearchPrefix())) {
            preference.setWebSearchPrefix(BowConfig.getWebSearchPrefix());
        }
        if (StringUtils.isBlank(preference.getAliasPrefix())) {
            preference.setAliasPrefix(BowConfig.getAliasPrefix());
        }
        if (StringUtils.isBlank(preference.getDefaultPrefix())) {
            preference.setDefaultPrefix(BowConfig.getDefaultPrefix());
        }
        if (StringUtils.isBlank(preference.getDefaultAction())) {
            preference.setDefaultAction(BowConfig.getDefaultAction());
        }
    }

    public String getPermanentToken() {
        return getUser().getPermanentToken();
    }

    public String getTemporaryToken() {
        return temporaryToken;
    }

    public void setTemporaryToken(String temporaryToken) {
        this.temporaryToken = temporaryToken;
    }

    public boolean isAdmin() {
        return admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

}
