/*
 * #%L
 * bow
 * 
 * $Id: BowProxy.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/BowProxy.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.WikittyExtension;

import java.util.ArrayList;
import java.util.List;

/**
 * Proxy pour utiliser les wikitty convenablement initialise.
 *
 * @author poussin
 * @version $Revision: 324 $
 *          <p/>
 *          Last update: $Date: 2011-08-29 14:21:36 +0200 (Mon, 29 Aug 2011) $
 *          by : $Author: tchemit $
 */
public class BowProxy extends WikittyProxy {

    static protected WikittyService ws;

    protected BowProxy(ApplicationConfig config, WikittyService ws) {
        super(config, ws);
    }

    /**
     * Return instance of BowProxy with specified security token
     *
     * @param token
     * @return
     */
    public static BowProxy getInstance(String token) {
        ApplicationConfig config = BowConfig.getConfig();
        WikittyService ws = getWikittyService(config);
        BowProxy result = new BowProxy(config, ws);
        result.setSecurityToken(token);

        return result;
    }

    /**
     * Return WikittyService to use. This WikittyService is singleton.
     *
     * @param config
     * @return
     */
    static protected WikittyService getWikittyService(ApplicationConfig config) {
        if (ws == null) {
            synchronized (BowProxy.class) {
                if (ws == null) {
                    List<WikittyExtension> extensions = new ArrayList<WikittyExtension>();
                    extensions.addAll(BowPreferenceImpl.extensions); // inherit BowUSer, WikittyUser
                    extensions.addAll(BowImportImpl.extensions); // inherit BowBookmark, WikittyLabel

                    ws = WikittyServiceFactory.buildWikittyService(config);
                    ws.storeExtension(null, extensions);
                }
            }
        }
        return ws;
    }

}
