package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class BowPreferenceHelper {

    /**
     * BowPreferenceHelper :
     * utility class all provided methods are accessible the static way
     */

    private BowPreferenceHelper() {// empty
}

    /**
     * getTags :
     * @param wikitty 
     * @return int 
     */

    public static int getTags(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGS);
        return value;
}

    /**
     * setTags :
     * @param wikitty 
     * @param tags 
     * @return int 
     */

    public static int setTags(Wikitty wikitty, int tags) {
        int oldValue = getTags(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGS, tags);
        return oldValue;
}

    /**
     * getBookmarks :
     * @param wikitty 
     * @return int 
     */

    public static int getBookmarks(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS);
        return value;
}

    /**
     * setBookmarks :
     * @param wikitty 
     * @param bookmarks 
     * @return int 
     */

    public static int setBookmarks(Wikitty wikitty, int bookmarks) {
        int oldValue = getBookmarks(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS, bookmarks);
        return oldValue;
}

    /**
     * getColors :
     * @param wikitty 
     * @return String 
     */

    public static String getColors(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_COLORS);
        return value;
}

    /**
     * setColors :
     * @param wikitty 
     * @param colors 
     * @return String 
     */

    public static String setColors(Wikitty wikitty, String colors) {
        String oldValue = getColors(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_COLORS, colors);
        return oldValue;
}

    /**
     * getSearchEngineUrlSuggestions :
     * @param wikitty 
     * @return String 
     */

    public static String getSearchEngineUrlSuggestions(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLSUGGESTIONS);
        return value;
}

    /**
     * setSearchEngineUrlSuggestions :
     * @param wikitty 
     * @param searchEngineUrlSuggestions 
     * @return String 
     */

    public static String setSearchEngineUrlSuggestions(Wikitty wikitty, String searchEngineUrlSuggestions) {
        String oldValue = getSearchEngineUrlSuggestions(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLSUGGESTIONS, searchEngineUrlSuggestions);
        return oldValue;
}

    /**
     * getSearchEngineUrlResults :
     * @param wikitty 
     * @return String 
     */

    public static String getSearchEngineUrlResults(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLRESULTS);
        return value;
}

    /**
     * setSearchEngineUrlResults :
     * @param wikitty 
     * @param searchEngineUrlResults 
     * @return String 
     */

    public static String setSearchEngineUrlResults(Wikitty wikitty, String searchEngineUrlResults) {
        String oldValue = getSearchEngineUrlResults(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLRESULTS, searchEngineUrlResults);
        return oldValue;
}

    /**
     * getDefaultAction :
     * @param wikitty 
     * @return String 
     */

    public static String getDefaultAction(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTACTION);
        return value;
}

    /**
     * setDefaultAction :
     * @param wikitty 
     * @param defaultAction 
     * @return String 
     */

    public static String setDefaultAction(Wikitty wikitty, String defaultAction) {
        String oldValue = getDefaultAction(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTACTION, defaultAction);
        return oldValue;
}

    /**
     * getDefaultPrefix :
     * @param wikitty 
     * @return String 
     */

    public static String getDefaultPrefix(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTPREFIX);
        return value;
}

    /**
     * setDefaultPrefix :
     * @param wikitty 
     * @param defaultPrefix 
     * @return String 
     */

    public static String setDefaultPrefix(Wikitty wikitty, String defaultPrefix) {
        String oldValue = getDefaultPrefix(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTPREFIX, defaultPrefix);
        return oldValue;
}

    /**
     * getTagSearchPrefix :
     * @param wikitty 
     * @return String 
     */

    public static String getTagSearchPrefix(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGSEARCHPREFIX);
        return value;
}

    /**
     * setTagSearchPrefix :
     * @param wikitty 
     * @param tagSearchPrefix 
     * @return String 
     */

    public static String setTagSearchPrefix(Wikitty wikitty, String tagSearchPrefix) {
        String oldValue = getTagSearchPrefix(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGSEARCHPREFIX, tagSearchPrefix);
        return oldValue;
}

    /**
     * getFullTextSearchPrefix :
     * @param wikitty 
     * @return String 
     */

    public static String getFullTextSearchPrefix(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_FULLTEXTSEARCHPREFIX);
        return value;
}

    /**
     * setFullTextSearchPrefix :
     * @param wikitty 
     * @param fullTextSearchPrefix 
     * @return String 
     */

    public static String setFullTextSearchPrefix(Wikitty wikitty, String fullTextSearchPrefix) {
        String oldValue = getFullTextSearchPrefix(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_FULLTEXTSEARCHPREFIX, fullTextSearchPrefix);
        return oldValue;
}

    /**
     * getWebSearchPrefix :
     * @param wikitty 
     * @return String 
     */

    public static String getWebSearchPrefix(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_WEBSEARCHPREFIX);
        return value;
}

    /**
     * setWebSearchPrefix :
     * @param wikitty 
     * @param webSearchPrefix 
     * @return String 
     */

    public static String setWebSearchPrefix(Wikitty wikitty, String webSearchPrefix) {
        String oldValue = getWebSearchPrefix(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_WEBSEARCHPREFIX, webSearchPrefix);
        return oldValue;
}

    /**
     * getAliasPrefix :
     * @param wikitty 
     * @return String 
     */

    public static String getAliasPrefix(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_ALIASPREFIX);
        return value;
}

    /**
     * setAliasPrefix :
     * @param wikitty 
     * @param aliasPrefix 
     * @return String 
     */

    public static String setAliasPrefix(Wikitty wikitty, String aliasPrefix) {
        String oldValue = getAliasPrefix(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_ALIASPREFIX, aliasPrefix);
        return oldValue;
}

    /**
     * getPrefixSeparator :
     * @param wikitty 
     * @return String 
     */

    public static String getPrefixSeparator(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_PREFIXSEPARATOR);
        return value;
}

    /**
     * setPrefixSeparator :
     * @param wikitty 
     * @param prefixSeparator 
     * @return String 
     */

    public static String setPrefixSeparator(Wikitty wikitty, String prefixSeparator) {
        String oldValue = getPrefixSeparator(wikitty);
        wikitty.setField(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_PREFIXSEPARATOR, prefixSeparator);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGS);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_COLORS);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_COLORS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLSUGGESTIONS);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLSUGGESTIONS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLRESULTS);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLRESULTS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTACTION);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTACTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTPREFIX);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_DEFAULTPREFIX);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGSEARCHPREFIX);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_TAGSEARCHPREFIX);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_FULLTEXTSEARCHPREFIX);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_FULLTEXTSEARCHPREFIX);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_WEBSEARCHPREFIX);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_WEBSEARCHPREFIX);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_ALIASPREFIX);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_ALIASPREFIX);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_PREFIXSEPARATOR);
            Object f2 = w2.getFieldAsObject(BowPreference.EXT_BOWPREFERENCE, BowPreference.FIELD_BOWPREFERENCE_PREFIXSEPARATOR);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(BowPreference.EXT_BOWPREFERENCE);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : BowPreferenceAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //BowPreferenceHelper
