package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class BowPreferenceAbstract extends BusinessEntityImpl implements BowPreference {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionBowPreference;
    /**
     * getTags :
     * @return int 
     */

    @Override
    public int getTags() {
        int value = BowPreferenceHelper.getTags(getWikitty());
        return value;
}

    /**
     * setTags :
     * @param tags 
     */

    @Override
    public void setTags(int tags) {
        int oldValue = getTags();
        BowPreferenceHelper.setTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_TAGS, oldValue, getTags());
}

    /**
     * getBookmarks :
     * @return int 
     */

    @Override
    public int getBookmarks() {
        int value = BowPreferenceHelper.getBookmarks(getWikitty());
        return value;
}

    /**
     * setBookmarks :
     * @param bookmarks 
     */

    @Override
    public void setBookmarks(int bookmarks) {
        int oldValue = getBookmarks();
        BowPreferenceHelper.setBookmarks(getWikitty(), bookmarks);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS, oldValue, getBookmarks());
}

    /**
     * getColors :
     * @return String 
     */

    @Override
    public String getColors() {
        String value = BowPreferenceHelper.getColors(getWikitty());
        return value;
}

    /**
     * setColors :
     * @param colors 
     */

    @Override
    public void setColors(String colors) {
        String oldValue = getColors();
        BowPreferenceHelper.setColors(getWikitty(), colors);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_COLORS, oldValue, getColors());
}

    /**
     * getSearchEngineUrlSuggestions :
     * @return String 
     */

    @Override
    public String getSearchEngineUrlSuggestions() {
        String value = BowPreferenceHelper.getSearchEngineUrlSuggestions(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlSuggestions :
     * @param searchEngineUrlSuggestions 
     */

    @Override
    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        String oldValue = getSearchEngineUrlSuggestions();
        BowPreferenceHelper.setSearchEngineUrlSuggestions(getWikitty(), searchEngineUrlSuggestions);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLSUGGESTIONS, oldValue, getSearchEngineUrlSuggestions());
}

    /**
     * getSearchEngineUrlResults :
     * @return String 
     */

    @Override
    public String getSearchEngineUrlResults() {
        String value = BowPreferenceHelper.getSearchEngineUrlResults(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlResults :
     * @param searchEngineUrlResults 
     */

    @Override
    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        String oldValue = getSearchEngineUrlResults();
        BowPreferenceHelper.setSearchEngineUrlResults(getWikitty(), searchEngineUrlResults);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLRESULTS, oldValue, getSearchEngineUrlResults());
}

    /**
     * getDefaultAction :
     * @return String 
     */

    @Override
    public String getDefaultAction() {
        String value = BowPreferenceHelper.getDefaultAction(getWikitty());
        return value;
}

    /**
     * setDefaultAction :
     * @param defaultAction 
     */

    @Override
    public void setDefaultAction(String defaultAction) {
        String oldValue = getDefaultAction();
        BowPreferenceHelper.setDefaultAction(getWikitty(), defaultAction);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_DEFAULTACTION, oldValue, getDefaultAction());
}

    /**
     * getDefaultPrefix :
     * @return String 
     */

    @Override
    public String getDefaultPrefix() {
        String value = BowPreferenceHelper.getDefaultPrefix(getWikitty());
        return value;
}

    /**
     * setDefaultPrefix :
     * @param defaultPrefix 
     */

    @Override
    public void setDefaultPrefix(String defaultPrefix) {
        String oldValue = getDefaultPrefix();
        BowPreferenceHelper.setDefaultPrefix(getWikitty(), defaultPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_DEFAULTPREFIX, oldValue, getDefaultPrefix());
}

    /**
     * getTagSearchPrefix :
     * @return String 
     */

    @Override
    public String getTagSearchPrefix() {
        String value = BowPreferenceHelper.getTagSearchPrefix(getWikitty());
        return value;
}

    /**
     * setTagSearchPrefix :
     * @param tagSearchPrefix 
     */

    @Override
    public void setTagSearchPrefix(String tagSearchPrefix) {
        String oldValue = getTagSearchPrefix();
        BowPreferenceHelper.setTagSearchPrefix(getWikitty(), tagSearchPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_TAGSEARCHPREFIX, oldValue, getTagSearchPrefix());
}

    /**
     * getFullTextSearchPrefix :
     * @return String 
     */

    @Override
    public String getFullTextSearchPrefix() {
        String value = BowPreferenceHelper.getFullTextSearchPrefix(getWikitty());
        return value;
}

    /**
     * setFullTextSearchPrefix :
     * @param fullTextSearchPrefix 
     */

    @Override
    public void setFullTextSearchPrefix(String fullTextSearchPrefix) {
        String oldValue = getFullTextSearchPrefix();
        BowPreferenceHelper.setFullTextSearchPrefix(getWikitty(), fullTextSearchPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_FULLTEXTSEARCHPREFIX, oldValue, getFullTextSearchPrefix());
}

    /**
     * getWebSearchPrefix :
     * @return String 
     */

    @Override
    public String getWebSearchPrefix() {
        String value = BowPreferenceHelper.getWebSearchPrefix(getWikitty());
        return value;
}

    /**
     * setWebSearchPrefix :
     * @param webSearchPrefix 
     */

    @Override
    public void setWebSearchPrefix(String webSearchPrefix) {
        String oldValue = getWebSearchPrefix();
        BowPreferenceHelper.setWebSearchPrefix(getWikitty(), webSearchPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_WEBSEARCHPREFIX, oldValue, getWebSearchPrefix());
}

    /**
     * getAliasPrefix :
     * @return String 
     */

    @Override
    public String getAliasPrefix() {
        String value = BowPreferenceHelper.getAliasPrefix(getWikitty());
        return value;
}

    /**
     * setAliasPrefix :
     * @param aliasPrefix 
     */

    @Override
    public void setAliasPrefix(String aliasPrefix) {
        String oldValue = getAliasPrefix();
        BowPreferenceHelper.setAliasPrefix(getWikitty(), aliasPrefix);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_ALIASPREFIX, oldValue, getAliasPrefix());
}

    /**
     * getPrefixSeparator :
     * @return String 
     */

    @Override
    public String getPrefixSeparator() {
        String value = BowPreferenceHelper.getPrefixSeparator(getWikitty());
        return value;
}

    /**
     * setPrefixSeparator :
     * @param prefixSeparator 
     */

    @Override
    public void setPrefixSeparator(String prefixSeparator) {
        String oldValue = getPrefixSeparator();
        BowPreferenceHelper.setPrefixSeparator(getWikitty(), prefixSeparator);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_PREFIXSEPARATOR, oldValue, getPrefixSeparator());
}

    /**
     * BowPreferenceAbstract :
     */

    public BowPreferenceAbstract() {
        super();
}

    /**
     * BowPreferenceAbstract :
     * @param wikitty 
     */

    public BowPreferenceAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * BowPreferenceAbstract :
     * @param businessEntityImpl 
     */

    public BowPreferenceAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionBowPreference =
                new WikittyExtension(EXT_BOWPREFERENCE,
                                     "3.0", // version
                                     (List)null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Numeric tags unique=\"true\"", 
                                             "Numeric bookmarks unique=\"true\"", 
                                             "String colors unique=\"true\"", 
                                             "String searchEngineUrlSuggestions unique=\"true\"", 
                                             "String searchEngineUrlResults unique=\"true\"", 
                                             "String defaultAction unique=\"true\" documentation=\"Indique l'action par defaut a faire, si l'utilisateur n'indique ni prefix ni separateur de prefix\"", 
                                             "String defaultPrefix unique=\"true\" documentation=\"Retourne le prefix par defaut a utiliser si l'utilisateur a mis le separateur de prefix mais sans prefix\"", 
                                             "String tagSearchPrefix unique=\"true\" documentation=\"le prefix pour indiquer que l'on souhaite une recherche sur les tags\"", 
                                             "String fullTextSearchPrefix unique=\"true\" documentation=\"le prefix pour indiquer que l'on souhaite une recherche sur fulltext dans bow\"", 
                                             "String webSearchPrefix unique=\"true\" documentation=\"le prefix pour indiquer que l'on souhaite une recherche sur le web via le moteur de recherche configurer\"", 
                                             "String aliasPrefix unique=\"true\" documentation=\"le prefix pour indiquer que l'on souhaite une recherche sur les alias prive et une rediection automatique vers cette page\"", 
                                             "String prefixSeparator unique=\"true\" documentation=\"Retourne le separateur choisi par l'utilisateur entre les prefix d'action et la chaine\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionBowPreference);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //BowPreferenceAbstract
