/*
 * #%L
 * BOW UI
 * 
 * $Id: BowMigration06To11.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/BowMigration06To11.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisationHelper;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.services.WikittyExtensionMigration;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRename;

import java.util.List;

/**
 * Migre les données depuis la version 0.6 vers la version 1.1.
 * On suppose que les données sont convenablement indexee.
 * <p/>
 * <li> ajout du champs BowBookmark.authentificationInfo (rien a faire pour la migration)
 * <li> suppression de BowBookmark.bowUser
 * <li> BowBookmark depend de WikittyAuthorisation
 * <p/>
 * la valeur de BowBookmark.bowUser est maintenant stockee dans
 * WikittyAuthorisation.owner et WikittyAuthorisation.reader
 * pour que par defaut seul le owner est les droits de lecture sur l'item
 *
 * @author poussin
 * @version $Revision: 324 $
 *          <p/>
 *          Last update: $Date: 2011-08-29 14:21:36 +0200 (Mon, 29 Aug 2011) $
 *          by : $Author: tchemit $
 */
public class BowMigration06To11 extends WikittyExtensionMigrationRename {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(BowMigration06To11.class);

    /** nombre d'objet a charger en 1 fois */
    public static final int MAX = 1000;

    /** Point d'entree de la migration. */
    @Override
    public Wikitty migrate(WikittyService service, Wikitty wikitty,
                           WikittyExtension oldExt, WikittyExtension newExt) {
        // on laisse l'implantation par defaut migrer tout ce qu'il faut
        // nouvelle dependance, ...
        Wikitty result = super.migrate(service, wikitty, oldExt, newExt);

        // On met juste a jour les données avec le champs supprimer bowUser
        String bookId = wikitty.getId();
        String userId = (String) wikitty.getFqField(
                BowBookmark.EXT_BOWBOOKMARK + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                + "bowUser");
        if (userId == null) {
            log.error(String.format("BowBookmark without bowUser info: %s", bookId));
        } else {
            WikittyAuthorisationHelper.setOwner(result, userId);
            WikittyAuthorisationHelper.addReader(result, userId);
        }

        return result;
    }

    public static void migrate(WikittyProxy proxy) {
        log.info("Migration 0.5 to 0.6 started");
        // on enregistre la classe qui fera la migration des données
        WikittyExtensionMigration.migrationRegistry.put(
                BowBookmark.EXT_BOWBOOKMARK, new BowMigration06To11());

        // une simple lecture puis ecrire fera automatiquement la migration
        // grace a la classe enregistree pour.
        Criteria criteria =
                Search.query().exteq(BowBookmark.EXT_BOWBOOKMARK).criteria();
        int i = 0;
        int count = 0;
        PagedResult<Wikitty> wikitties;
        do {
            criteria.setFirstIndex(i);
            criteria.setEndIndex(i += MAX);
            wikitties = proxy.findAllByCriteria(criteria);
            List<Wikitty> books = wikitties.getAll();
            proxy.storeWikitty(books);
            count += books.size();
        } while (wikitties.size() >= MAX);
        log.info(String.format("Migration of %s BowBookmark done", count));
    }

    // only here to simplify test and debug of migration, this permit to migrate
    // datas in developpement environnement directly without launch bow web app
    public static void main(String... args) {
        BowProxy proxy = BowProxy.getInstance(null);
        migrate(proxy);
    }
}
