/*
 * #%L
 * BOW UI
 * 
 * $Id: BowMigration04To05.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/BowMigration04To05.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.search.PagedResult;

import java.util.ArrayList;
import java.util.List;

/**
 * Migre les données depuis la version 0.4 vers la version 0.5.
 * On suppose que les données sont convenablement indexee.
 * <p/>
 * <li> renomage de User -> BowUser (qui hérite de WikittyUser)
 * <li> renomage de Preference -> BowPreference
 * <li> renomage de Bookmark -> BowBookmark
 * <li> renomage de Import -> BowImport
 * <p/>
 * <li> deplacement de User.email -> BowUser(WikittyUser).login
 * <li> deplacement de User.password -> BowUser(WikittyUser).password
 * <li> deplacement de Token.token -> BowUser.permanentToken
 * <li> deplacement de Bookmark.date -> BowBookmark.creationDate
 * <li> deplacement de Bookmark.alias -> BowBookmark.privateAlias
 * <li> deplacement de Bookmark.tags -> BowBookmark(WikittyLabel).labels
 * <li> deplacement de Import.date -> BowImport(BowBookmark).importDate
 * <p/>
 * <li> suppression de Token
 * <p/>
 * <li> remplacement de Bookmark.email -> lien vers BowUser
 * <p/>
 * <li> ajout sur BowBookmark d'un lien vers BowImport
 * <li> ajout sur BowImport d'un lien vers BowUser
 * <p/>
 * Le nouvel objet BowAlias a ete ajoute, rien est a faire avec pour la
 * migration.
 *
 * @author poussin
 * @version $Revision: 324 $
 *          <p/>
 *          Last update: $Date: 2011-08-29 14:21:36 +0200 (Mon, 29 Aug 2011) $
 *          by : $Author: tchemit $
 */
public class BowMigration04To05 {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(BowMigration04To05.class);

    /** nombre d'objet a charger en 1 fois */
    public static final int MAX = 100;

    /**
     * Point d'entree de la migration
     *
     * @param proxy
     */
    public static void migrate(WikittyProxy proxy) {
        UserImpl userExample = new UserImpl();
        int i = 0;
        PagedResult<UserImpl> pagedUser;
        do {
            pagedUser = proxy.findAllByExample(userExample, i, i += MAX);
            List<UserImpl> users = pagedUser.getAll();
            List<BowUser> bowUsers = migrateUser(proxy, users);
            proxy.store(bowUsers);
            proxy.delete(users);
        } while (pagedUser.size() >= MAX);
    }

    public static List<BowUser> migrateUser(WikittyProxy proxy, List<UserImpl> users) {
        List<BowUser> result = new ArrayList<BowUser>(users.size());
        for (UserImpl user : users) {
            BowUser bowUser = new BowUserImpl();
            result.add(bowUser);

            // copie des informations du user
            bowUser.setLogin(user.getEmail());
            bowUser.setPassword(user.getPassword());

            // copie des preferences
            Preference pref = proxy.restore(Preference.class, user.getWikittyId());
            bowUser.setColors(pref.getColors());
            bowUser.setSearchEngineUrlResults(pref.getSearchEngineUrlResults());
            bowUser.setSearchEngineUrlSuggestions(pref.getSearchEngineUrlSuggestions());
            bowUser.setTags(pref.getTags());
            bowUser.setBookmarks(pref.getBookmarks());

            // copie du permanent token
            TokenImpl tokenExample = new TokenImpl();
            tokenExample.setEmail(user.getEmail());
            TokenImpl permanentToken = proxy.findByExample(tokenExample);
            bowUser.setPermanentToken(permanentToken.getToken());

            // migration des bookmarks
            BookmarkImpl bookmarkExample = new BookmarkImpl();
            bookmarkExample.setEmail(user.getEmail());
            int i = 0;
            PagedResult<BookmarkImpl> pagedBookmark;
            do {
                pagedBookmark = proxy.findAllByExample(bookmarkExample, i, i += MAX);
                List<BookmarkImpl> bookmarks = pagedBookmark.getAll();
                List<BowBookmark> bowbookmarks =
                        migrateBookmark(proxy, bowUser, bookmarks);
                proxy.store(bowbookmarks);
                proxy.delete(bookmarks);
            } while (pagedBookmark.size() >= MAX);
        }
        return result;
    }

    public static List<BowBookmark> migrateBookmark(WikittyProxy proxy, BowUser user,
                                                    List<BookmarkImpl> bookmarks) {
        List<BowBookmark> result = new ArrayList<BowBookmark>(bookmarks.size());
        for (BookmarkImpl bookmark : bookmarks) {
            BowBookmark bowBookmark = new BowBookmarkImpl();
            result.add(bowBookmark);

            // copie du bookmark
            bowBookmark.setOwner(user.getWikittyId());
            bowBookmark.addReader(user.getWikittyId());
            bowBookmark.setClick(bookmark.getClick());
            bowBookmark.setCreationDate(bookmark.getDate());
            bowBookmark.setDescription(bookmark.getDescription());
            bowBookmark.setLabels(bookmark.getTags());
            bowBookmark.setLink(bookmark.getLink());
            bowBookmark.setPrivateAlias(bookmark.getAlias());

            // copie de l'import si besoin
            Wikitty w = proxy.getWikitty(bookmark);
            if (ImportHelper.hasExtension(w)) {
                Wikitty bowImport = proxy.getWikitty(bowBookmark);
                BowImportHelper.addExtension(bowImport);
                BowImportHelper.setImportDate(bowImport, ImportHelper.getDate(w));
            }
        }
        return result;
    }

}
