/*
 * #%L
 * bow
 * 
 * $Id: BowConfig.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/BowConfig.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfigOption;

/**
 * @author poussin
 * @version $Revision: 324 $
 *          <p/>
 *          Last update: $Date: 2011-08-29 14:21:36 +0200 (Mon, 29 Aug 2011) $
 *          by : $Author: tchemit $
 */
public class BowConfig {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(BowConfig.class);

    /** Singleton instance. */
    protected static ApplicationConfig config;

    /**
     * constructeur public seulement pour pouvoir mettre une variable de ce
     * type dans BowBaseAction et acceder facilement au donnees dans les jsp
     * en ognl
     */
    public BowConfig() {
    }

    public static ApplicationConfig getConfig(String... args) {
        if (config == null) {
            synchronized (BowConfig.class) {
                if (config == null) {
                    try {
                        config = new ApplicationConfig(BowConfigOption.CONFIG_FILE.getDefaultValue());

                        // Load wikitty options
                        config.loadDefaultOptions(WikittyConfigOption.class);

                        // Load bow options
                        config.loadDefaultOptions(BowConfigOption.class);

                        // Parse args
                        config.parse(args);
                    } catch (Exception e) {
                        throw new UnhandledException(e);
                    }
                }
            }
        }
        return config;
    }

    /**
     * Get version as string.
     * Default bow applicationConfig will be used
     *
     * @return version
     */
    public static String getVersion() {
        return getVersion(getConfig());
    }

    /**
     * Get version as string.
     *
     * @param config bow configuration
     * @return version
     */
    public static String getVersion(ApplicationConfig config) {
        return config.getOption(BowConfigOption.APPLICATION_VERSION.key);
    }

    /**
     * Get bow url as string.
     * Default bow applicationConfig will be used
     *
     * @return url
     */
    public static String getBowUrl() {
        return getBowUrl(getConfig());
    }

    /**
     * Get bow url as string.
     *
     * @param config bow configuration
     * @return url
     */
    public static String getBowUrl(ApplicationConfig config) {
        String result = config.getOption(BowConfigOption.BOW_URL.key);
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    /**
     * Get alias url as string.
     * Default bow applicationConfig will be used
     *
     * @return url
     */
    public static String getAliasUrl() {
        return getAliasUrl(getConfig());
    }

    /**
     * Get alias url as string.
     *
     * @param config bow configuration
     * @return url
     */
    public static String getAliasUrl(ApplicationConfig config) {
        String result = config.getOption(BowConfigOption.ALIAS_URL.key);
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    /**
     * Get bow smtp server as string.
     * Default bow applicationConfig will be used
     *
     * @return smtpServer
     */
    public static String getSmtpServer() {
        return getSmtpServer(getConfig());
    }

    /**
     * Get bow smtp server as string.
     *
     * @param config bow configuration
     * @return smtpServer
     */
    public static String getSmtpServer(ApplicationConfig config) {
        return config.getOption(BowConfigOption.BOW_SMTPSERVER.key);
    }

    /**
     * Get default search engine
     * Default bow applicationConfig will be used
     *
     * @return search engine url
     */
    public static String getSearchEngine() {
        return getSearchEngine(getConfig());
    }

    /**
     * Get default search engine
     *
     * @param config bow configuration
     * @return search engine url
     */
    public static String getSearchEngine(ApplicationConfig config) {
        return config.getOption(BowConfigOption.SEARCH_ENGINE.key);
    }

    /**
     * Get bow address from as string.
     * Default bow applicationConfig will be used
     *
     * @return addressFrom
     */
    public static String getAddressFrom() {
        return getAddressFrom(getConfig());
    }

    /**
     * Get bow address from as string.
     *
     * @param config bow configuration
     * @return addressFrom
     */
    public static String getAddressFrom(ApplicationConfig config) {
        return config.getOption(BowConfigOption.BOW_ADDRESSFROM.key);
    }

    /**
     * Get admins accounts
     * Default bow applicationConfig will be used
     *
     * @return admins
     */
    public static String[] getAdmins() {
        return getAdmins(getConfig());
    }

    /**
     * Get admins accounts
     *
     * @param config bow configuration
     * @return admins
     */
    public static String[] getAdmins(ApplicationConfig config) {
        String str = config.getOption(BowConfigOption.BOW_ADMINS.key);
        return StringUtil.split(str, ",");
    }

    /**
     * Return password for specified admin email
     * Default bow applicationConfig will be used
     *
     * @param admin emails account
     * @return null or password if available
     */
    public static String getAdminPassword(String admin) {
        return getAdminPassword(getConfig(), admin);
    }

    /**
     * Return password for specified admin email
     *
     * @param config bow configuration
     * @param admin  emails account
     * @return null or password if available
     */
    public static String getAdminPassword(ApplicationConfig config, String admin) {
        return config.getOption(BowConfigOption.BOW_ADMINS.key + ".password." + admin);
    }

    /**
     * Retourne le separateur choisi par l'utilisateur entre les prefix d'action
     * et la chaine.
     *
     * @return
     */
    public static String getPrefixSeparator() {
        return getPrefixSeparator(getConfig());
    }

    /**
     * Retourne le separateur choisi par l'utilisateur entre les prefix d'action
     * et la chaine.
     *
     * @return
     */
    public static String getPrefixSeparator(ApplicationConfig config) {
        return config.getOption(BowConfigOption.OPEN_SEARCH_PREFIX_SEPARATOR.key);
    }

    /**
     * Retourne le prefix par defaut a utiliser si l'utilisateur a mis le
     * separateur de prefix mais sans prefix
     *
     * @return
     */
    public static String getDefaultPrefix() {
        return getDefaultPrefix(getConfig());
    }

    /**
     * Retourne le prefix par defaut a utiliser si l'utilisateur a mis le
     * separateur de prefix mais sans prefix
     *
     * @return
     */
    public static String getDefaultPrefix(ApplicationConfig config) {
        return config.getOption(BowConfigOption.OPEN_SEARCH_DEFAULT_PREFIX.key);
    }

    /**
     * Indique l'action par defaut a faire, si l'utilisateur n'indique ni
     * prefix ni separateur de prefix
     *
     * @return
     */
    public static String getDefaultAction() {
        return getDefaultAction(getConfig());
    }

    /**
     * Indique l'action par defaut a faire, si l'utilisateur n'indique ni
     * prefix ni separateur de prefix
     *
     * @return
     */
    public static String getDefaultAction(ApplicationConfig config) {
        return config.getOption(BowConfigOption.OPEN_SEARCH_DEFAULT_ACTION.key);
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur les tags
     *
     * @return
     */
    public static String getTagSearchPrefix() {
        return getTagSearchPrefix(getConfig());
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur les tags
     *
     * @return
     */
    public static String getTagSearchPrefix(ApplicationConfig config) {
        return config.getOption(BowConfigOption.OPEN_SEARCH_TAG_SEARCH_PREFIX.key);
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur fulltext
     * dans bow
     *
     * @return
     */
    public static String getFullTextSearchPrefix() {
        return getFullTextSearchPrefix(getConfig());
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur fulltext
     * dans bow
     *
     * @return
     */
    public static String getFullTextSearchPrefix(ApplicationConfig config) {
        return config.getOption(BowConfigOption.OPEN_SEARCH_FULLTEXT_SEARCH_PREFIX.key);
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur les alias
     * prive et une rediection automatique vers cette page
     *
     * @return
     */
    public static String getAliasPrefix() {
        return getAliasPrefix(getConfig());
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur les alias
     * prive et une rediection automatique vers cette page
     *
     * @return
     */
    public static String getAliasPrefix(ApplicationConfig config) {
        return config.getOption(BowConfigOption.OPEN_SEARCH_ALIAS_PREFIX.key);
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur le web
     * via le moteur de recherche configurer
     *
     * @return
     */
    public static String getWebSearchPrefix() {
        return getWebSearchPrefix(getConfig());
    }

    /**
     * le prefix pour indiquer que l'on souhaite une recherche sur le web
     * via le moteur de recherche configurer
     *
     * @return
     */
    public static String getWebSearchPrefix(ApplicationConfig config) {
        return config.getOption(BowConfigOption.OPEN_SEARCH_WEB_SEARCH_PREFIX.key);
    }

}
