package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class BowBookmarkHelper {

    /**
     * BowBookmarkHelper :
     * utility class all provided methods are accessible the static way
     */

    private BowBookmarkHelper() {// empty
}

    /**
     * getLink :
     * @param wikitty 
     * @return String 
     */

    public static String getLink(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK);
        return value;
}

    /**
     * setLink :
     * @param wikitty 
     * @param link 
     * @return String 
     */

    public static String setLink(Wikitty wikitty, String link) {
        String oldValue = getLink(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK, link);
        return oldValue;
}

    /**
     * getDescription :
     * @param wikitty 
     * @return String 
     */

    public static String getDescription(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION);
        return value;
}

    /**
     * setDescription :
     * @param wikitty 
     * @param description 
     * @return String 
     */

    public static String setDescription(Wikitty wikitty, String description) {
        String oldValue = getDescription(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION, description);
        return oldValue;
}

    /**
     * getCreationDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getCreationDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE);
        return value;
}

    /**
     * setCreationDate :
     * @param wikitty 
     * @param creationDate 
     * @return Date 
     */

    public static Date setCreationDate(Wikitty wikitty, Date creationDate) {
        Date oldValue = getCreationDate(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE, creationDate);
        return oldValue;
}

    /**
     * getClick :
     * @param wikitty 
     * @return int 
     */

    public static int getClick(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK);
        return value;
}

    /**
     * setClick :
     * @param wikitty 
     * @param click 
     * @return int 
     */

    public static int setClick(Wikitty wikitty, int click) {
        int oldValue = getClick(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK, click);
        return oldValue;
}

    /**
     * getPrivateAlias :
     * @param wikitty 
     * @return String 
     */

    public static String getPrivateAlias(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS);
        return value;
}

    /**
     * setPrivateAlias :
     * @param wikitty 
     * @param privateAlias 
     * @return String 
     */

    public static String setPrivateAlias(Wikitty wikitty, String privateAlias) {
        String oldValue = getPrivateAlias(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS, privateAlias);
        return oldValue;
}

    /**
     * getPublicAlias :
     * @param wikitty 
     * @return String 
     */

    public static String getPublicAlias(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS);
        return value;
}

    /**
     * setPublicAlias :
     * @param wikitty 
     * @param publicAlias 
     * @return String 
     */

    public static String setPublicAlias(Wikitty wikitty, String publicAlias) {
        String oldValue = getPublicAlias(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS, publicAlias);
        return oldValue;
}

    /**
     * getAuthentificationInfo :
     * @param wikitty 
     * @return String 
     */

    public static String getAuthentificationInfo(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO);
        return value;
}

    /**
     * setAuthentificationInfo :
     * @param wikitty 
     * @param authentificationInfo 
     * @return String 
     */

    public static String setAuthentificationInfo(Wikitty wikitty, String authentificationInfo) {
        String oldValue = getAuthentificationInfo(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO, authentificationInfo);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(BowBookmark.EXT_BOWBOOKMARK);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : BowBookmarkAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //BowBookmarkHelper
