package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisation;
import org.nuiton.wikitty.entities.WikittyAuthorisationAbstract;
import org.nuiton.wikitty.entities.WikittyAuthorisationHelper;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelAbstract;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class BowBookmarkAbstract extends BusinessEntityImpl implements BowBookmark {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionBowBookmark;
    /**
     * getLink :
     * @return String 
     */

    @Override
    public String getLink() {
        String value = BowBookmarkHelper.getLink(getWikitty());
        return value;
}

    /**
     * setLink :
     * @param link 
     */

    @Override
    public void setLink(String link) {
        String oldValue = getLink();
        BowBookmarkHelper.setLink(getWikitty(), link);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_LINK, oldValue, getLink());
}

    /**
     * getDescription :
     * @return String 
     */

    @Override
    public String getDescription() {
        String value = BowBookmarkHelper.getDescription(getWikitty());
        return value;
}

    /**
     * setDescription :
     * @param description 
     */

    @Override
    public void setDescription(String description) {
        String oldValue = getDescription();
        BowBookmarkHelper.setDescription(getWikitty(), description);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION, oldValue, getDescription());
}

    /**
     * getCreationDate :
     * @return Date 
     */

    @Override
    public Date getCreationDate() {
        Date value = BowBookmarkHelper.getCreationDate(getWikitty());
        return value;
}

    /**
     * setCreationDate :
     * @param creationDate 
     */

    @Override
    public void setCreationDate(Date creationDate) {
        Date oldValue = getCreationDate();
        BowBookmarkHelper.setCreationDate(getWikitty(), creationDate);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE, oldValue, getCreationDate());
}

    /**
     * getClick :
     * @return int 
     */

    @Override
    public int getClick() {
        int value = BowBookmarkHelper.getClick(getWikitty());
        return value;
}

    /**
     * setClick :
     * @param click 
     */

    @Override
    public void setClick(int click) {
        int oldValue = getClick();
        BowBookmarkHelper.setClick(getWikitty(), click);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_CLICK, oldValue, getClick());
}

    /**
     * getPrivateAlias :
     * @return String 
     */

    @Override
    public String getPrivateAlias() {
        String value = BowBookmarkHelper.getPrivateAlias(getWikitty());
        return value;
}

    /**
     * setPrivateAlias :
     * @param privateAlias 
     */

    @Override
    public void setPrivateAlias(String privateAlias) {
        String oldValue = getPrivateAlias();
        BowBookmarkHelper.setPrivateAlias(getWikitty(), privateAlias);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS, oldValue, getPrivateAlias());
}

    /**
     * getPublicAlias :
     * @return String 
     */

    @Override
    public String getPublicAlias() {
        String value = BowBookmarkHelper.getPublicAlias(getWikitty());
        return value;
}

    /**
     * setPublicAlias :
     * @param publicAlias 
     */

    @Override
    public void setPublicAlias(String publicAlias) {
        String oldValue = getPublicAlias();
        BowBookmarkHelper.setPublicAlias(getWikitty(), publicAlias);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS, oldValue, getPublicAlias());
}

    /**
     * getAuthentificationInfo :
     * @return String 
     */

    @Override
    public String getAuthentificationInfo() {
        String value = BowBookmarkHelper.getAuthentificationInfo(getWikitty());
        return value;
}

    /**
     * setAuthentificationInfo :
     * @param authentificationInfo 
     */

    @Override
    public void setAuthentificationInfo(String authentificationInfo) {
        String oldValue = getAuthentificationInfo();
        BowBookmarkHelper.setAuthentificationInfo(getWikitty(), authentificationInfo);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO, oldValue, getAuthentificationInfo());
}

    /**
     * getLabels :
     * @return Set<String> 
     */

    public Set<String> getLabels() {
        Set<String> result = WikittyLabelHelper.getLabels(getWikitty());
        return result;
}

    /**
     * setLabels :
     * @param labels 
     */

    public void setLabels(Set<String> labels) {
        Set<String> oldValue = getLabels();
        WikittyLabelHelper.setLabels(getWikitty(), labels);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    /**
     * addAllLabels :
     * @param labels 
     */

    public void addAllLabels(Set<String> labels) {
        Set<String> oldValue = getLabels();
        WikittyLabelHelper.addAllLabels(getWikitty(), labels);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    /**
     * addLabels :
     * @param element 
     */

    public void addLabels(String element) {
        WikittyLabelHelper.addLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * removeLabels :
     * @param element 
     */

    public void removeLabels(String element) {
        WikittyLabelHelper.removeLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * clearLabels :
     */

    public void clearLabels() {
        WikittyLabelHelper.clearLabels(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * setExtensionForMetaExtension :
     * add WikittyAuthorisation meta-extension on given extension to this entity
     * @param extension 
     */

    public void setExtensionForMetaExtension(WikittyExtension extension) {
        extensionForMetaExtension = extension;
        WikittyAuthorisationHelper.addMetaExtension(extension, getWikitty());
}

    /**
     * getOwner :
     * @return String 
     */

    public String getOwner() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyAuthorisationHelper.getOwner(getWikitty());
        } else {
            value = WikittyAuthorisationHelper.getOwner(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    /**
     * setOwner :
     * @param owner 
     */

    public void setOwner(String owner) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getOwner();
            WikittyAuthorisationHelper.setOwner(getWikitty(), owner);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, oldValue, getOwner());
        } else {
            oldValue = getOwner();
            WikittyAuthorisationHelper.setOwner(extensionForMetaExtension.getName(), getWikitty(), owner);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "owner");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getOwner());
        }
}

    /**
     * getAdmin :
     * @return Set<String> 
     */

    public Set<String> getAdmin() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getAdmin(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getAdmin(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * setAdmin :
     * @param values 
     */

    public void setAdmin(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.setAdmin(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.setAdmin(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * addAllAdmin :
     * @param values 
     */

    public void addAllAdmin(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAllAdmin(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.addAllAdmin(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * addAdmin :
     * @param element 
     */

    public void addAdmin(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAdmin(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.addAdmin(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * removeAdmin :
     * @param element 
     */

    public void removeAdmin(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeAdmin(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.removeAdmin(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * clearAdmin :
     */

    public void clearAdmin() {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearAdmin(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.clearAdmin(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * getWriter :
     * @return Set<String> 
     */

    public Set<String> getWriter() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getWriter(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getWriter(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * setWriter :
     * @param values 
     */

    public void setWriter(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.setWriter(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.setWriter(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * addAllWriter :
     * @param values 
     */

    public void addAllWriter(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAllWriter(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.addAllWriter(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * addWriter :
     * @param element 
     */

    public void addWriter(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addWriter(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.addWriter(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * removeWriter :
     * @param element 
     */

    public void removeWriter(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeWriter(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.removeWriter(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * clearWriter :
     */

    public void clearWriter() {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearWriter(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.clearWriter(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * getReader :
     * @return Set<String> 
     */

    public Set<String> getReader() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getReader(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getReader(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * setReader :
     * @param values 
     */

    public void setReader(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.setReader(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.setReader(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * addAllReader :
     * @param values 
     */

    public void addAllReader(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAllReader(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.addAllReader(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * addReader :
     * @param element 
     */

    public void addReader(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addReader(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.addReader(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * removeReader :
     * @param element 
     */

    public void removeReader(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeReader(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.removeReader(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * clearReader :
     */

    public void clearReader() {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearReader(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.clearReader(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * getParent :
     * @return String 
     */

    public String getParent() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyAuthorisationHelper.getParent(getWikitty());
        } else {
            value = WikittyAuthorisationHelper.getParent(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    /**
     * setParent :
     * @param parent 
     */

    public void setParent(String parent) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getParent();
            WikittyAuthorisationHelper.setParent(getWikitty(), parent);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, oldValue, getParent());
        } else {
            oldValue = getParent();
            WikittyAuthorisationHelper.setParent(extensionForMetaExtension.getName(), getWikitty(), parent);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "parent");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getParent());
        }
}

    /**
     * BowBookmarkAbstract :
     */

    public BowBookmarkAbstract() {
        super();
}

    /**
     * BowBookmarkAbstract :
     * @param wikitty 
     */

    public BowBookmarkAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * BowBookmarkAbstract :
     * @param businessEntityImpl 
     */

    public BowBookmarkAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionBowBookmark =
                new WikittyExtension(EXT_BOWBOOKMARK,
                                     "3.0", // version
                                     WikittyLabel.EXT_WIKITTYLABEL + "," + WikittyAuthorisation.EXT_WIKITTYAUTHORISATION,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String link unique=\"true\"", 
                                             "String description unique=\"true\"", 
                                             "Date creationDate unique=\"true\"", 
                                             "Numeric click unique=\"true\"", 
                                             "String privateAlias unique=\"true\"", 
                                             "String publicAlias unique=\"true\"", 
                                             "String authentificationInfo unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyLabelAbstract.extensions); 
        // current after requires ones

        exts.addAll(WikittyAuthorisationAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBowBookmark);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //BowBookmarkAbstract
