package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class BookmarkAbstract extends BusinessEntityImpl implements Bookmark {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionBookmark;
    /**
     * getLink :
     * @return String 
     */

    @Override
    public String getLink() {
        String value = BookmarkHelper.getLink(getWikitty());
        return value;
}

    /**
     * setLink :
     * @param link 
     */

    @Override
    public void setLink(String link) {
        String oldValue = getLink();
        BookmarkHelper.setLink(getWikitty(), link);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_LINK, oldValue, getLink());
}

    /**
     * getDescription :
     * @return String 
     */

    @Override
    public String getDescription() {
        String value = BookmarkHelper.getDescription(getWikitty());
        return value;
}

    /**
     * setDescription :
     * @param description 
     */

    @Override
    public void setDescription(String description) {
        String oldValue = getDescription();
        BookmarkHelper.setDescription(getWikitty(), description);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_DESCRIPTION, oldValue, getDescription());
}

    /**
     * getTags :
     * @return Set<String> 
     */

    @Override
    public Set<String> getTags() {
        Set<String> result = BookmarkHelper.getTags(getWikitty());
        return result;
}

    /**
     * setTags :
     * @param tags 
     */

    @Override
    public void setTags(Set<String> tags) {
        Set<String> oldValue = getTags();
        BookmarkHelper.setTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_TAGS, oldValue, getTags());
}

    /**
     * addAllTags :
     * @param tags 
     */

    @Override
    public void addAllTags(Set<String> tags) {
        Set<String> oldValue = getTags();
        BookmarkHelper.addAllTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_TAGS, oldValue, getTags());
}

    /**
     * addTags :
     * @param element 
     */

    @Override
    public void addTags(String element) {
        BookmarkHelper.addTags(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_TAGS, null, getTags());
}

    /**
     * removeTags :
     * @param element 
     */

    @Override
    public void removeTags(String element) {
        BookmarkHelper.removeTags(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_TAGS, null, getTags());
}

    /**
     * clearTags :
     */

    @Override
    public void clearTags() {
        BookmarkHelper.clearTags(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_TAGS, null, getTags());
}

    /**
     * getDate :
     * @return Date 
     */

    @Override
    public Date getDate() {
        Date value = BookmarkHelper.getDate(getWikitty());
        return value;
}

    /**
     * setDate :
     * @param date 
     */

    @Override
    public void setDate(Date date) {
        Date oldValue = getDate();
        BookmarkHelper.setDate(getWikitty(), date);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_DATE, oldValue, getDate());
}

    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        String value = BookmarkHelper.getEmail(getWikitty());
        return value;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        String oldValue = getEmail();
        BookmarkHelper.setEmail(getWikitty(), email);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_EMAIL, oldValue, getEmail());
}

    /**
     * getClick :
     * @return int 
     */

    @Override
    public int getClick() {
        int value = BookmarkHelper.getClick(getWikitty());
        return value;
}

    /**
     * setClick :
     * @param click 
     */

    @Override
    public void setClick(int click) {
        int oldValue = getClick();
        BookmarkHelper.setClick(getWikitty(), click);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_CLICK, oldValue, getClick());
}

    /**
     * getAlias :
     * @return String 
     */

    @Override
    public String getAlias() {
        String value = BookmarkHelper.getAlias(getWikitty());
        return value;
}

    /**
     * setAlias :
     * @param alias 
     */

    @Override
    public void setAlias(String alias) {
        String oldValue = getAlias();
        BookmarkHelper.setAlias(getWikitty(), alias);
        getPropertyChangeSupport().firePropertyChange(Bookmark.FIELD_BOOKMARK_ALIAS, oldValue, getAlias());
}

    /**
     * BookmarkAbstract :
     */

    public BookmarkAbstract() {
        super();
}

    /**
     * BookmarkAbstract :
     * @param wikitty 
     */

    public BookmarkAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * BookmarkAbstract :
     * @param businessEntityImpl 
     */

    public BookmarkAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionBookmark =
                new WikittyExtension(EXT_BOOKMARK,
                                     "2.0", // version
                                     (List)null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String link unique=\"true\"", 
                                             "String description unique=\"true\"", 
                                             "String tags[0-*] unique=\"true\"", 
                                             "Date date unique=\"true\"", 
                                             "String email unique=\"true\"", 
                                             "Numeric click unique=\"true\"", 
                                             "String alias unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionBookmark);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //BookmarkAbstract
