/*
 * #%L
 * bow
 * 
 * $Id: SearchAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/SearchAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowPreference;
import org.chorem.bow.BowSearch;

import static org.nuiton.i18n.I18n.n_;

/**
 * gere les recherches de bookmark
 *
 * @author poussin
 */
public class SearchAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = -2161661766242362907L;
    protected String searchLine;
    protected String fullTextLine;
    protected String addTag;
    protected HttpServletRequest request;

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    /**
     * @return the addTag
     */
    public String getAddTag() {
        return addTag;
    }

    /**
     * @param addTag the addTag to set
     */
    public void setAddTag(String addTag) {
        this.addTag = addTag;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }

    /**
     * Searches a bookmark
     */
    public String execute() {
        try {
            BowPreference user = getBowSession().getPreference();
            BowSearch.search(request, user);
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
            
    }
}