/*
 * #%L
 * bow
 * 
 * $Id: RegisterAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/RegisterAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowMail;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUserImpl;
import org.chorem.bow.BowInit;
import org.chorem.bow.BowPreference;
import org.chorem.bow.BowUtils;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * Enregistre un nouvel utilisateur
 *
 * @author poussin
 */
public class RegisterAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 2204772861770399542L;
    protected String email;
    protected String password;
    protected String repeatPassword;
    protected HttpServletRequest request;
    
    /**
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * @param email the email to set
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the repeatPassword
     */
    public String getRepeatPassword() {
        return repeatPassword;
    }

    /**
     * @param repeatPassword the repeatPassword to set
     */
    public void setRepeatPassword(String repeatPassword) {
        this.repeatPassword = repeatPassword;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }
    
    /**
     * 
     * @param passwordMD5 the user password hashed in md5
     * @return false if the email address isn't already registered, true
     * otherwise
     */
    protected boolean alreadyRegistered(String passwordMD5) {
        boolean result = true;

	if (email != null && passwordMD5 != null) {
	    if (!email.isEmpty() && !passwordMD5.equals(StringUtil.encodeMD5(""))) {
		WikittyProxy proxy = getBowProxy();
		Criteria criteria = Search.query().eq(BowUser.FQ_FIELD_WIKITTYUSER_LOGIN, email).criteria(); //Retrieves user by user name (email)

		//If the user doesn't already exist
		if (proxy.findByCriteria(BowUser.class, criteria) == null) {
		    result = false;
		} else { //The email address is already used by someone
		    addFieldError("email", getText(n_("bow.register.emailAldyUsed")));
		}
	    }
	}
	return result;
    }

    /**
     * Registers the new user and sends an email to confirm registration
     */
    public String execute() {
        String result = INPUT;

        try {
            if (email != null) {
                email = email.trim();
                if (password != null) {
                    if (!password.equals(repeatPassword)) {
                        addActionError(getText(n_("bow.register.pwdDontMatch")));
                    } else {
                        String md5 = StringUtil.encodeMD5(password);

                        //If the email address isn't already used
                        if (!alreadyRegistered(md5)) {
                            WikittyProxy proxy = getBowProxy();
                            BowUserImpl newUser = new BowUserImpl();
                            newUser.setPassword(md5);
                            newUser.setLogin(email);
                            String permanentToken = BowUtils.generateToken();
                            newUser.setPermanentToken(permanentToken);
                            BowUser login = proxy.store(newUser); //Stores the new user

                            //If there was an error when storing the user
                            if (login == null) {
                                addFieldError("email", getText(n_("bow.register.invalidLogin")));
                            } else {
                                getBowSession().setUser(login);
                                BowPreference pref = getBowSession().getPreference();
                                BowInit.initHomePage(request, pref);

                                try {
                                    String mailContent;

                                    mailContent = getText(n_("bow.register.mailHi")) + ",\n\n" + getText(n_("bow.register.mailPwd")) + ": " + password + "\n\n" + getText(n_("bow.register.mailEmail")) + ": " + email + "\n\n";
                                    BowMail.sendMail(email, getText(n_("bow.register.mailSubject")), mailContent);
                                } catch (AddressException e) {
                                    //If the email address is invalid
                                    String message = getText("bow.mail.badFormat");

                                    addActionError(n_(message));
                                    log.error(message + " (email:" + email + ")", e);
                                } catch (MessagingException e) {
                                    String message = getText("bow.mail.sendError");

                                    addActionError(n_(message));
                                    log.error(message + "(" + e.getMessage() + ")", e);
                                }
                                result = SUCCESS;
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return result;
    }
}
