/*
 * #%L
 * bow
 * 
 * $Id: RedirectToUrlAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/RedirectToUrlAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.BowBookmark;
import org.nuiton.wikitty.WikittyProxy;

import static org.nuiton.i18n.I18n.n_;

/**
 * Retrieves the bookmark URL (where the user will be redirected) and increments 
 * the click counter for this bookmark
 *
 */
public class RedirectToUrlAction extends BowBaseAction {
    
    private static final long serialVersionUID = 8579081104294143087L;

    protected String bookmarkId;
    protected String link;

    /**
     * @return the bookmarkId
     */
    public String getBookmarkId() {
        return bookmarkId;
    }
    /**
     * @param bookmarkId the bookmarkId to set
     */
    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    /**
     * @return the link
     */
    public String getLink() {
        return link;
    }
    /**
     * @param link the link to set
     */
    public void setLink(String link) {
        this.link = link;
    }

    /**
     * Increments the click counter and sets the link (retrieved by Struts2)
     * where the user will be redirected
     */
    public String execute() {
        String result = ERROR;
        
        try {
            if (bookmarkId != null && !bookmarkId.isEmpty()) {
                WikittyProxy proxy = getBowProxy();
                BowBookmark bookmark = proxy.restore(BowBookmark.class, bookmarkId);
                if (bookmark != null) {
                    bookmark.setClick(bookmark.getClick() + 1);
                    proxy.store(bookmark);
                    setLink(bookmark.getLink());
                    result = SUCCESS;
                }
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return result;
    }
    
}