/*
 * #%L
 * bow
 * 
 * $Id: PreferencesAction.java 285 2011-05-16 13:21:52Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/PreferencesAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowInit;
import org.chorem.bow.BowPreference;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.FacetTopicNameComparator;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * Change les preferences de l'utilisateur (couleur, password, email, ...)
 * 
 * @author poussin
 */
public class PreferencesAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = -58341106356599721L;
    
    static public PreferencesAction getAction() {
        Object action = ActionContext.getContext().get(CONTEXT_ACTION_KEY);
        return (PreferencesAction) action;
    }

    protected String colors;
    protected String tagsNb;
    protected String bookmarksHomePage;
    protected String searchEngineUrlSuggestions;
    protected String searchEngineUrlResults;
    protected String email;
    protected String newPassword;
    protected String currentPassword;
    protected String confirmNewPassword;
    protected String update;
    protected Map<String, Integer> bookmarksImportDate;
    protected HttpServletRequest request;
    
    protected Set<FacetTopic> labels;
    protected String[] selectedLabels;
    protected String rename;
    protected String delete;
    protected String newLabel;

    public String getNewLabel() {
        return newLabel;
    }

    public void setNewLabel(String newLabel) {
        this.newLabel = newLabel;
    }
    
    public void setRename(String rename) {
        this.rename = rename;
    }

    public String getRename() {
        return rename;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public String getDelete() {
        return delete;
    }
    
    /**
     * @return the colors
     */
    public String getColors() {
        return colors;
    }

    /**
     * @param colors the colors to set
     */
    public void setColors(String colors) {
        this.colors = colors;
    }

    /**
     * @return the tagsNb
     */
    public String getTagsNb() {
        return tagsNb;
    }

    /**
     * @param tagsNb the tagsNb to set
     */
    public void setTagsNb(String tagsNb) {
        this.tagsNb = tagsNb;
    }

    /**
     * @return the bookmarksHomePage
     */
    public String getBookmarksHomePage() {
        return bookmarksHomePage;
    }

    /**
     * @param bookmarksHomePage the bookmarksHomePage to set
     */
    public void setBookmarksHomePage(String bookmarksHomePage) {
        this.bookmarksHomePage = bookmarksHomePage;
    }

    /**
     * @return the searchEngineUrlSuggestions
     */
    public String getSearchEngineUrlSuggestions() {
        return searchEngineUrlSuggestions;
    }

    /**
     * @param searchEngineUrlSuggestions the searchEngineUrlSuggestions to set
     */
    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        this.searchEngineUrlSuggestions = searchEngineUrlSuggestions;
    }

    /**
     * @return the searchEngineUrlResults
     */
    public String getSearchEngineUrlResults() {
        return searchEngineUrlResults;
    }

    /**
     * @param searchEngineUrlResults the searchEngineUrlResults to set
     */
    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        this.searchEngineUrlResults = searchEngineUrlResults;
    }

    /**
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * @param email the email to set
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * @return the newPassword
     */
    public String getNewPassword() {
        return newPassword;
    }

    /**
     * @param newPassword the newPassword to set
     */
    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    /**
     * @return the currentPassword
     */
    public String getCurrentPassword() {
        return currentPassword;
    }

    /**
     * @param currentPassword the currentPassword to set
     */
    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    /**
     * @return the confirmNewPassword
     */
    public String getConfirmNewPassword() {
        return confirmNewPassword;
    }

    /**
     * @param confirmNewPassword the confirmNewPassword to set
     */
    public void setConfirmNewPassword(String confirmNewPassword) {
        this.confirmNewPassword = confirmNewPassword;
    }

    /**
     * @return the update
     */
    public String getUpdate() {
        return update;
    }

    /**
     * @param update the update to set
     */
    public void setUpdate(String update) {
        this.update = update;
    }

    /**
     * @return the bookmarksImportDate
     */
    public Map<String, Integer> getBookmarksImportDate() {
        return bookmarksImportDate;
    }

    /**
     * @param bookmarksImportDate the bookmarksImportDate to set
     */
    public void setBookmarksImportDate(Map<String, Integer> bookmarksImportDate) {
        this.bookmarksImportDate = bookmarksImportDate;
    }

    public Set<FacetTopic> getLabels() {
        return labels;
    }

    public String[] getSelectedLabels() {
        return selectedLabels;
    }

    public void setSelectedLabels(String[] selectedLabels) {
        this.selectedLabels = selectedLabels;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    protected BowPreference changePreference(BowPreference preference) {
        preference.setColors(colors);
        if ((tagsNb != null && !tagsNb.isEmpty())) {
            preference.setTags(Integer.valueOf(tagsNb));
        }
        if (bookmarksHomePage != null && !bookmarksHomePage.isEmpty()) {
            preference.setBookmarks(Integer.valueOf(bookmarksHomePage));
        }
        preference.setSearchEngineUrlSuggestions(searchEngineUrlSuggestions);
        preference.setSearchEngineUrlResults(searchEngineUrlResults);

        return preference;
    }

    protected BowUser changeUser(BowUser newUser) {
	if (email != null && !email.isEmpty()) {
            newUser.setLogin(email);
        }
        if (newPassword != null && confirmNewPassword != null && currentPassword != null) {
            if (!newPassword.isEmpty() && !confirmNewPassword.isEmpty() && !currentPassword.isEmpty()) {
                if (newPassword.equals(confirmNewPassword)) {
                    currentPassword = StringUtil.encodeMD5(currentPassword);
                    if (currentPassword.equals(newUser.getPassword())) {
                        newUser.setPassword(StringUtil.encodeMD5(newPassword));
                    } else {
                        addFieldError("currentPassword", getText(n_("bow.preferences.badCurrentPassword")));
                        return null;
                    }
                }
            }
        }
        return newUser;
    }

    /**
     * Charge dans la variable labels tous les labels de l'utilisateur
     * @param proxy 
     */
    protected void loadLabels(WikittyProxy proxy) {
        BowUser user = getBowSession().getUser();
        String userId = user.getWikittyId();
        
        Criteria c = Search.query()
                .exteq(BowBookmark.EXT_WIKITTYLABEL)
                .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_BOWUSER, userId)
                .criteria().setEndIndex(0)
                .addFacetField(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS);
        PagedResult<Wikitty> result =  proxy.findAllByCriteria(c);
        List<FacetTopic> topics = result.getTopic(
                BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS);
        labels = new TreeSet<FacetTopic>(new FacetTopicNameComparator(true));
        labels.addAll(topics);
    }
    
    /**
     * Fait les modification demandé par l'utilisateur dans l'interface de 
     * preference: renome ou supprime des labels. Si l'utilisateur demande le
     * remplacement de label on indiquant pas de nouveau label, alors la chaine
     * vide est utilisee.
     * 
     * @return 
     */
    public String adminlabels() {
        String result = SUCCESS;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Selected labels: " + Arrays.toString(selectedLabels));
                log.debug("action delete: " + delete + " rename: " + rename);
            }

            List<String> selectedLabelsList = Arrays.asList(selectedLabels);
            boolean isRename = !StringUtils.isEmpty(rename);
            
            BowProxy proxy = getBowProxy();
            BowUser user = getBowSession().getUser();
            String userId = user.getWikittyId();
            
            Criteria c = Search.query()
                    .in(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS, selectedLabelsList)
                    .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_BOWUSER, userId)
                    .criteria();
            PagedResult<WikittyLabel> searchResult =
                    proxy.findAllByCriteria(WikittyLabel.class, c);
            
            List<WikittyLabel> toStore = new ArrayList<WikittyLabel>();
            for (WikittyLabel label : searchResult) {
                toStore.add(label);
                Set<String> l = label.getLabels();
                if (l != null) {
                    // on fait une copie, car l retourne est non modifiable
                    l = new HashSet<String>(l);
                    l.removeAll(selectedLabelsList);
                    if (isRename) {
                        l.add(newLabel);
                    }
                    label.setLabels(l);
                }
            }
            proxy.store(toStore);
        } catch (Exception eee) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(eee.getMessage(), eee);
        }
        return result;

    }
    
    /**
     * Changes the user preferences
     */
    public String execute() {
        String result = SUCCESS;
        
        try {
            BowProxy proxy = getBowSession().getProxy();
            // BowPreference extends BowUser, donc on l'utilise pour tout
            BowPreference preference = getBowSession().getPreference();

            loadLabels(proxy);
            Map<String,Integer> bookmarksByImportDate = BookmarkUtils.getBookmarksByImportDate(request, preference);

            if (log.isDebugEnabled()) {
                log.debug("bookmarksByImportDate found : " + (bookmarksByImportDate == null ? "null" : bookmarksByImportDate.size()));
            }
            setBookmarksImportDate(bookmarksByImportDate.isEmpty() ? null : bookmarksByImportDate);
            if (update != null) { //If the user submitted the form
                preference = changePreference(preference);
                preference = proxy.store(preference);
                getBowSession().setPreference(preference);

                Criteria criteria = Search.query().eq(BowUser.FQ_FIELD_WIKITTYUSER_LOGIN, email).criteria();
                BowUser find = proxy.findByCriteria(BowUser.class, criteria);

                //If this email address isn't already used (or if it hasn't changed)
                if (find == null || find.getLogin().equals(preference.getLogin())) {
                    BowUser newUser = changeUser(preference);
                    if (newUser == null) {
                        result = ERROR;
                    } else {
                        newUser = proxy.store(newUser);
                        getBowSession().setUser(newUser);
                        result = "update";
                        addActionMessage(getText(n_("bow.preferences.update.successful")));
                    }
                } else {
                    // this email address is already used by someone else
                    setEmail(preference.getLogin());
                    addActionError(getText("bow.preferences.emailAldyExists"));
                    result = ERROR;
                }
            } else {
                // If the user didn't submit the form, the fields are filled with
                // the current preferences values
                setEmail(preference.getLogin());
                setColors(preference.getColors());
                setTagsNb(String.valueOf(preference.getTags()));
                setBookmarksHomePage(String.valueOf(preference.getBookmarks()));
                setSearchEngineUrlSuggestions(preference.getSearchEngineUrlSuggestions());
                setSearchEngineUrlResults(preference.getSearchEngineUrlResults());                
            }
            // retrieve last reference
            preference = getBowSession().getPreference();
            BowInit.initHomePage(request, preference);
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return result;
    }
}
