/*
 * #%L
 * bow
 * 
 * $Id: HomeAction.java 276 2011-04-29 21:02:55Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/HomeAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowInit;
import org.chorem.bow.BowPreference;

import static org.nuiton.i18n.I18n.n_;

/**
 * Prepare l'affichage de la page d'accueil
 * 
 * @author poussin
 */
public class HomeAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = -3735250067223062719L;
    protected String token;
    protected HttpServletRequest request;
    
    /**
     * @return the token
     */
    public String getToken() {
        return token;
    }
    /**
     * @param token the token to set
     */
    public void setToken(String token) {
        this.token = token;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    /**
     * Initializes everything before displaying the home page
     */
    public String execute() {
        try {
            BowPreference user = getBowSession().getPreference();
            
            BowInit.initHomePage(request, user);
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
    }
}