/*
 * #%L
 * bow
 * 
 * $Id: GenerateTokenAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/GenerateTokenAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.nuiton.wikitty.WikittyProxy;

import static org.nuiton.i18n.I18n.n_;

/**
 * Force la regeneration de token permanent et temporaire
 * 
 * @author poussin
 */
public class GenerateTokenAction extends BowBaseAction {

    private static final long serialVersionUID = 1141019772989666309L;

    /**
     * Generates a new permanent and temporary token
     */
    public String execute() {
        try {
            BowUser user = getBowSession().getUser();
            WikittyProxy proxy = getBowProxy();
            
            String permanentToken = BowUtils.generateToken();
            user.setPermanentToken(permanentToken);
            proxy.store(user);
            
            String temporaryToken = BowUtils.generateToken();
            getBowSession().setTemporaryToken(temporaryToken);
            addActionMessage(getText(n_("bow.token.generate.successful")));
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
    }
}