/*
 * #%L
 * bow
 * 
 * $Id: ExportBookmarksAction.java 232 2011-03-10 11:29:17Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/ExportBookmarksAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowUser;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 * Export son bookmark au format HTML
 *
 * @author poussin
 */
public class ExportBookmarksAction extends BowBaseAction implements ServletResponseAware {
    private static final long serialVersionUID = 45880214686011946L;
    protected HttpServletResponse response;
    protected InputStream inputStream;

    @Override
    public void setServletResponse(HttpServletResponse response) {
	    this.response = response;
    }

    public InputStream getInputStream() {
        return inputStream;
    }
    
    /**
     * Exports the bookmarks in HTML format
     */
    public String execute() {
        WikittyProxy proxy = getBowProxy();

        // get current user
        BowUser user = getBowSession().getUser();

        // Get all bookmark for user
        Criteria criteria = Search.query()
                .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_BOWUSER, user.getWikittyId()).criteria();
        List<BowBookmark> bookmarks = proxy.findAllByCriteria(BowBookmark.class, criteria).getAll();

        // Export all
        String export = BookmarkUtils.getExportHtmlBookmark(bookmarks);
        BufferedWriter out = null;
        
        try {

            // Write result in temp file
            File tmp = File.createTempFile("bookmarks", ".tmp.html");
            
            tmp.deleteOnExit();
            out = new BufferedWriter(new FileWriter(tmp));
            out.write(export);
            
            inputStream  = new FileInputStream(tmp);
        } catch (IOException e) {
            log.error("Error when exporting bookmarks to HTML : " + e.getMessage(), e);
        } finally {
            IOUtils.closeQuietly(out);
        }
        return SUCCESS;
    }
}