/*
 * #%L
 * bow
 * 
 * $Id: DeleteSearchResultsAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/action/DeleteSearchResultsAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.util.ArrayList;
import java.util.List;

import org.chorem.bow.BowBookmark;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowPreference;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * Supprime des bookmarks qui satisfont le critere de recherche. Si fullTextLine
 * est non vide, alors elle est utilisee, pour la recherche, sinon on utilise
 * searchLine
 *
 * @author poussin
 */
public class DeleteSearchResultsAction extends BowBaseAction {
    
    private static final long serialVersionUID = -3903724044644625507L;
    protected String searchLine;
    protected String fullTextLine;

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    /**
     * Deletes the search results
     */
    public String execute() {
        try {
            if (searchLine != null && fullTextLine != null) {
                WikittyProxy proxy = getBowProxy();
                Criteria criteria;
                BowPreference user = getBowSession().getPreference();

                if (fullTextLine.isEmpty()) {
                    criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, searchLine);
                } else {
                    criteria = Search.query().keyword(fullTextLine)
                    .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_BOWUSER, user.getWikittyId()).criteria()
                    .addFacetField(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS);
                }
                List<BowBookmark> bookmarks = proxy.findAllByCriteria(BowBookmark.class, criteria).getAll();
                List<String> ids = new ArrayList<String>();

                // TODO poussin 20110216 a revoir, incomprehensible :(
                for (BowBookmark bookmark : bookmarks) {
                    if (bookmark != null) {
                        if (searchLine.isEmpty() && bookmark.getLabels() == null ||
                                !searchLine.isEmpty() || fullTextLine.isEmpty() &&
                                bookmark.getLabels() == null || !fullTextLine.isEmpty()) {
                            ids.add(bookmark.getWikittyId());
                        }
                    }
                }
                proxy.delete(ids);
                addActionMessage(getText(n_("bow.search.results.deleted")));
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
    }
}