package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class TokenHelper {

    /**
     * TokenHelper :
     * utility class all provided methods are accessible the static way
     */

    private TokenHelper() {// empty
}

    /**
     * getToken :
     * @param wikitty 
     * @return String 
     */

    public static String getToken(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Token.EXT_TOKEN, Token.FIELD_TOKEN_TOKEN);
        return value;
}

    /**
     * setToken :
     * @param wikitty 
     * @param token 
     * @return String 
     */

    public static String setToken(Wikitty wikitty, String token) {
        String oldValue = getToken(wikitty);
        wikitty.setField(Token.EXT_TOKEN, Token.FIELD_TOKEN_TOKEN, token);
        return oldValue;
}

    /**
     * getEmail :
     * @param wikitty 
     * @return String 
     */

    public static String getEmail(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Token.EXT_TOKEN, Token.FIELD_TOKEN_EMAIL);
        return value;
}

    /**
     * setEmail :
     * @param wikitty 
     * @param email 
     * @return String 
     */

    public static String setEmail(Wikitty wikitty, String email) {
        String oldValue = getEmail(wikitty);
        wikitty.setField(Token.EXT_TOKEN, Token.FIELD_TOKEN_EMAIL, email);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Token.EXT_TOKEN, Token.FIELD_TOKEN_TOKEN);
            Object f2 = w2.getFieldAsObject(Token.EXT_TOKEN, Token.FIELD_TOKEN_TOKEN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Token.EXT_TOKEN, Token.FIELD_TOKEN_EMAIL);
            Object f2 = w2.getFieldAsObject(Token.EXT_TOKEN, Token.FIELD_TOKEN_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Token.EXT_TOKEN);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : TokenAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //TokenHelper
