/*
 * #%L
 * bow
 * 
 * $Id: BowUtils.java 283 2011-05-12 14:29:07Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/BowUtils.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

import java.util.UUID;
import org.apache.commons.lang.time.DateFormatUtils;

public class BowUtils {

    final static public String BOW_DATE_SHORT_PATTERN = "yyyy/MM/dd";
    
    private BowUtils() {
    }

    static public String formatDate(Date date) {
        String result = DateFormatUtils.format(date, BOW_DATE_SHORT_PATTERN);
        return result;
    }
    /**
     * Generates a random token
     * 
     * @return the generated token
     */
    static public String generateToken() {
        UUID uuid = UUID.randomUUID();
        String tokenGenerated = uuid.toString();
        tokenGenerated = StringUtil.encodeMD5(tokenGenerated); // encode the token in MD5
        return tokenGenerated; // return the generated token
    }

    /**
     * Redirects the user either on the home page or on the search page
     * 
     * @param searchLine search line
     * @param fullTextLine full text search
     * @return the page where the user will be redirected
     */
    static public String redirectTo(String searchLine, String fullTextLine) {
        String result = "home.action";

        if (!StringUtils.isEmpty(searchLine) || !StringUtils.isEmpty(fullTextLine)) {
            result = "search.action?";
            if (searchLine != null) {
                result += "searchLine=" + searchLine;
            }
            if (searchLine != null && fullTextLine != null) {
                result += "&";
            }
            if (fullTextLine != null) {
                 result += "fullTextLine=" + fullTextLine;
            }
        }
        return result;
    }
    
    /**
     * Retrieves the user by the temporary or the permanent token
     * 
     * @param session the session
     * @param token either the temporary or the permanent token
     * @return the user if the token is valid, null if the token doesn't exist
     */
    static public BowUser checkToken(BowSession session, String token) {
        BowUser result = null;
        if (checkTemporaryToken(session, token) || checkPermanentToken(session, token)) {
            result = session.getUser();
        }
        return result;
    }

    /**
     * check if token exist, if true, put User associated with it, in BowSession
     *
     * @param session bow session
     * @param token which contains the MD5 encoding token
     * @return User the token owner, null if the token doesn't exist
     */
    protected static boolean checkPermanentToken(BowSession session, String token) {
        WikittyProxy proxy = session.getProxy();
        boolean result = false;
        if (token != null) {
            Criteria criteria = Search.query().eq(
                    BowUser.FQ_FIELD_BOWUSER_PERMANENTTOKEN, token).criteria();
            BowUser user = proxy.findByCriteria(BowUser.class, criteria);
            if (user != null) {
                session.setUser(user);
                result = true;
            }
        }
        return result;
    }

    /**
     * Check token with temporary token
     *
     * @param session bow session
     * @param token which contains the MD5 encoding token
     * @return user the token owner, null if the token doesn't exist
     */
    protected static boolean checkTemporaryToken(BowSession session, String token) {
        String temporaryToken = session.getTemporaryToken();
        boolean result = temporaryToken != null && temporaryToken.equals(token);
        return result;
    }
}
