package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class BowUserAbstract extends BusinessEntityImpl implements BowUser {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionBowUser;
    /**
     * getPermanentToken :
     * @return String 
     */

    @Override
    public String getPermanentToken() {
        String value = BowUserHelper.getPermanentToken(getWikitty());
        return value;
}

    /**
     * setPermanentToken :
     * @param permanentToken 
     */

    @Override
    public void setPermanentToken(String permanentToken) {
        String oldValue = getPermanentToken();
        BowUserHelper.setPermanentToken(getWikitty(), permanentToken);
        getPropertyChangeSupport().firePropertyChange(BowUser.FIELD_BOWUSER_PERMANENTTOKEN, oldValue, getPermanentToken());
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        String value = WikittyUserHelper.getLogin(getWikitty());
        return value;
}

    /**
     * setLogin :
     * @param login 
     */

    public void setLogin(String login) {
        String oldValue = getLogin();
        WikittyUserHelper.setLogin(getWikitty(), login);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        String value = WikittyUserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    public void setPassword(String password) {
        String oldValue = getPassword();
        WikittyUserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    /**
     * BowUserAbstract :
     */

    public BowUserAbstract() {
        super();
}

    /**
     * BowUserAbstract :
     * @param wikitty 
     */

    public BowUserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * BowUserAbstract :
     * @param businessEntityImpl 
     */

    public BowUserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionBowUser =
                new WikittyExtension(EXT_BOWUSER,
                                     "1.0", // version
                                     WikittyUser.EXT_WIKITTYUSER,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String permanentToken unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyUserAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBowUser);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //BowUserAbstract
