/*
 * #%L
 * bow
 * 
 * $Id: BowSession.java 285 2011-05-16 13:21:52Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/BowSession.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.Wikitty;

/**
 * Classe utilisee pour stocker les objets utils en session utilisateur
 *
 * @author poussin
 * @version $Revision: 285 $
 *
 * Last update: $Date: 2011-05-16 15:21:52 +0200 (lun., 16 mai 2011) $
 * by : $Author: sletellier $
 */
public class BowSession {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(BowSession.class);

    static final private String BOW_SESSION_KEY = BowSession.class.getSimpleName();

    protected BowProxy proxy;
    // preference herite de user, on ne stocke que preference
    protected BowPreference preference = null;
    protected String temporaryToken = null;
    protected boolean admin = false;

    public BowSession() {
        proxy = BowProxy.getInstance(null);
    }

    static public void invalidate(Map<String, Object> session) {
        session.remove(BOW_SESSION_KEY);
    }

    static public BowSession getBowSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        BowSession result = getBowSession(session);
        return result;
    }

    static public BowSession getBowSession(HttpSession httpSession) {
        BowSession result = (BowSession) httpSession.getAttribute(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            httpSession.setAttribute(BOW_SESSION_KEY, result);
        }
        return result;
    }

    static public BowSession getBowSession(Map<String, Object> session) {
        BowSession result = (BowSession)session.get(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            session.put(BOW_SESSION_KEY, result);
        }
        return result;
    }

    public BowProxy getProxy() {
        return proxy;
    }

    public BowPreference getPreference() {
        return preference;
    }

    public void setPreference(BowPreference preference) {
        // si c'est le meme objet on ne fait rien
        if (this.preference == preference) {
            return;
        }

        if (preference != null) {
            checkPreference(preference);

            // check if this user is admin
            String login = preference.getLogin();
            String[] admins = BowConfig.getAdmins();
            boolean isAdmin = false;
            if (admins != null) {
                for (String admin : admins) {
                    if (login.equals(admin)) {
                        isAdmin = true;
                        break;
                    }
                }
            }
            setAdmin(isAdmin);

            // si c'est le meme user, on ne regenere pas le temporaryToken
            if (!ObjectUtils.equals(this.preference, preference)) {
                // generate temporary token
                String temporaryToken = BowUtils.generateToken();
                setTemporaryToken(temporaryToken);
            }
        }
        this.preference = preference;
    }

    public BowUser getUser() {
        return preference;
    }

    public void setUser(BowUser user) {
        // si c'est le meme objet on ne fait rien
        if (this.preference == user) {
            return;
        }

        BowPreference preference = null;
        if (user != null) {
            // load user preference
            preference = getProxy().restore(BowPreference.class, user.getWikittyId());
            if (preference == null) {
                Wikitty w = getProxy().getWikitty(user);
                preference = new BowPreferenceImpl(w);
            }
        }
        setPreference(preference);
    }

     protected void checkPreference(BowPreference preference) {
        if (preference.getBookmarks() <= 0) {
            preference.setBookmarks(100); // set default to 100
        }
        if (preference.getTags() <= 0) {
            preference.setTags(100); // set default to 100
        }
        if (preference.getColors() == null) {
            preference.setColors("");
        }
        if (preference.getSearchEngineUrlResults() == null) {
            preference.setSearchEngineUrlResults(BowConfig.getSearchEngine());
        }
        if (preference.getSearchEngineUrlSuggestions() == null) {
            preference.setSearchEngineUrlSuggestions(""); // TODO add default value in config
        }
    }
    
    public String getPermanentToken() {
        return getUser().getPermanentToken();
    }

    public String getTemporaryToken() {
        return temporaryToken;
    }

    public void setTemporaryToken(String temporaryToken) {
        this.temporaryToken = temporaryToken;
    }

    public boolean isAdmin() {
        return admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

}
