/*
 * #%L
 * bow
 * 
 * $Id: BowSearch.java 211 2011-02-18 18:12:04Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/BowSearch.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import javax.servlet.http.HttpServletRequest;

import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

public class BowSearch {

    static public void search(HttpServletRequest request, BowPreference user) {
        String searchLine = request.getParameter("searchLine");

        if (searchLine == null) {
            searchLine = "";
        }
        String fulltext = request.getParameter("fullTextLine");

        if (fulltext != null && !fulltext.isEmpty() && searchLine.isEmpty()) {
            fullText(request, user);
        } else {
            String tag = request.getParameter("addTag");

            if (tag != null && !tag.isEmpty()) {
                if (searchLine.isEmpty()) {
                    searchLine = tag;
                } else {
                    searchLine += " " + tag;
                }
            }
            BowSession session = BowSession.getBowSession(request);
            WikittyProxy proxy = session.getProxy();
            Criteria criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, searchLine);
            
            if (criteria != null ) {
                criteria = criteria.addSortDescending(BowBookmark.FQ_FIELD_BOWBOOKMARK_CLICK);

                if (criteria != null) {
                    PagedResult<BowBookmark> result =
                        proxy.findAllByCriteria(BowBookmark.class, criteria); //Selects all bookmarks by user
                    BookmarkActions bookmarkActions = BookmarkUtils.createBookmarkActions(request, result, searchLine);
                    request.setAttribute("bookmarkActions", bookmarkActions);
                }
            }
        }
    }

    static public void fullText(HttpServletRequest request, BowPreference user) {
        String fullText = request.getParameter("fullTextLine");

        if (fullText == null || fullText.isEmpty()) {
            search(request, user);
        } else {
            BowSession session = BowSession.getBowSession(request);
            WikittyProxy proxy = session.getProxy();
            Criteria criteria;

            if (!fullText.isEmpty()) {
                criteria = Search.query().keyword(fullText).
                        eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_BOWUSER, user.getWikittyId()).criteria().
                        addFacetField(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS);
            } else {
                criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, null);
            }
            PagedResult<BowBookmark> result = proxy.findAllByCriteria(BowBookmark.class, criteria);
            BookmarkActions bookmarkActions = BookmarkUtils.createBookmarkActions(request, result, null);
            request.setAttribute("bookmarkActions", bookmarkActions);
        }
    }
}
