package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class BowPreferenceAbstract extends BusinessEntityImpl implements BowPreference {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionBowPreference;
    /**
     * getTags :
     * @return int 
     */

    @Override
    public int getTags() {
        int value = BowPreferenceHelper.getTags(getWikitty());
        return value;
}

    /**
     * setTags :
     * @param tags 
     */

    @Override
    public void setTags(int tags) {
        int oldValue = getTags();
        BowPreferenceHelper.setTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_TAGS, oldValue, getTags());
}

    /**
     * getBookmarks :
     * @return int 
     */

    @Override
    public int getBookmarks() {
        int value = BowPreferenceHelper.getBookmarks(getWikitty());
        return value;
}

    /**
     * setBookmarks :
     * @param bookmarks 
     */

    @Override
    public void setBookmarks(int bookmarks) {
        int oldValue = getBookmarks();
        BowPreferenceHelper.setBookmarks(getWikitty(), bookmarks);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS, oldValue, getBookmarks());
}

    /**
     * getColors :
     * @return String 
     */

    @Override
    public String getColors() {
        String value = BowPreferenceHelper.getColors(getWikitty());
        return value;
}

    /**
     * setColors :
     * @param colors 
     */

    @Override
    public void setColors(String colors) {
        String oldValue = getColors();
        BowPreferenceHelper.setColors(getWikitty(), colors);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_COLORS, oldValue, getColors());
}

    /**
     * getSearchEngineUrlSuggestions :
     * @return String 
     */

    @Override
    public String getSearchEngineUrlSuggestions() {
        String value = BowPreferenceHelper.getSearchEngineUrlSuggestions(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlSuggestions :
     * @param searchEngineUrlSuggestions 
     */

    @Override
    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        String oldValue = getSearchEngineUrlSuggestions();
        BowPreferenceHelper.setSearchEngineUrlSuggestions(getWikitty(), searchEngineUrlSuggestions);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLSUGGESTIONS, oldValue, getSearchEngineUrlSuggestions());
}

    /**
     * getSearchEngineUrlResults :
     * @return String 
     */

    @Override
    public String getSearchEngineUrlResults() {
        String value = BowPreferenceHelper.getSearchEngineUrlResults(getWikitty());
        return value;
}

    /**
     * setSearchEngineUrlResults :
     * @param searchEngineUrlResults 
     */

    @Override
    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        String oldValue = getSearchEngineUrlResults();
        BowPreferenceHelper.setSearchEngineUrlResults(getWikitty(), searchEngineUrlResults);
        getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_SEARCHENGINEURLRESULTS, oldValue, getSearchEngineUrlResults());
}

    /**
     * getPermanentToken :
     * @return String 
     */

    public String getPermanentToken() {
        String value = BowUserHelper.getPermanentToken(getWikitty());
        return value;
}

    /**
     * setPermanentToken :
     * @param permanentToken 
     */

    public void setPermanentToken(String permanentToken) {
        String oldValue = getPermanentToken();
        BowUserHelper.setPermanentToken(getWikitty(), permanentToken);
        getPropertyChangeSupport().firePropertyChange(BowUser.FIELD_BOWUSER_PERMANENTTOKEN, oldValue, getPermanentToken());
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        String value = WikittyUserHelper.getLogin(getWikitty());
        return value;
}

    /**
     * setLogin :
     * @param login 
     */

    public void setLogin(String login) {
        String oldValue = getLogin();
        WikittyUserHelper.setLogin(getWikitty(), login);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        String value = WikittyUserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    public void setPassword(String password) {
        String oldValue = getPassword();
        WikittyUserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    /**
     * BowPreferenceAbstract :
     */

    public BowPreferenceAbstract() {
        super();
}

    /**
     * BowPreferenceAbstract :
     * @param wikitty 
     */

    public BowPreferenceAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * BowPreferenceAbstract :
     * @param businessEntityImpl 
     */

    public BowPreferenceAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionBowPreference =
                new WikittyExtension(EXT_BOWPREFERENCE,
                                     "1.0", // version
                                     BowUser.EXT_BOWUSER,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Numeric tags unique=\"true\"", 
                                             "Numeric bookmarks unique=\"true\"", 
                                             "String colors unique=\"true\"", 
                                             "String searchEngineUrlSuggestions unique=\"true\"", 
                                             "String searchEngineUrlResults unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(BowUserAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBowPreference);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //BowPreferenceAbstract
