/*
 * #%L
 * BOW UI
 * 
 * $Id: BowConfigOption.java 291 2011-05-17 15:01:13Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/BowConfigOption.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import org.nuiton.util.ApplicationConfig;

import static org.nuiton.i18n.I18n._;

/**
 * Bow option definition.
 */
public enum BowConfigOption implements ApplicationConfig.OptionDef {

    CONFIG_FILE(
            ApplicationConfig.CONFIG_FILE_NAME,
            _("bow.config.configFileName.description"),
            "bow.properties", String.class, false, false),
    APPLICATION_VERSION(
            "application.version",
            _("bow.config.application.version.description"),
            null, String.class, true, true),
    BOW_URL(
            "bow.url",
            _("bow.config.bow.url.description"),
            null, String.class, false, false),
    // For apache url rewriting
    ALIAS_URL(
            "alias.url",
            _("bow.config.alias.url.description"),
            "alias/", String.class, false, false),
    SERVLET_BOW(
            "servlet.bow",
            _("bow.config.servlet.bow.description"),
            null, String.class, false, false),
    // For apache url rewriting
    SERVLET_ALIAS(
            "servlet.alias",
            _("bow.config.servlet.bow.description"),
            null, String.class, false, false),
    SEARCH_ENGINE(
            "search.engine",
            _("bow.config.search.engine.description"),
            null, String.class, false, false),
    BOW_SMTPSERVER(
            "bow.smtpServer",
            _("bow.config.bow.smtpServer.description"),
            null, String.class, false, false),
    BOW_ADDRESSFROM(
            "bow.addressFrom",
            _("bow.config.bow.addressFrom.description"),
            null, String.class, false, false),
    BOW_ADMINS(
            "bow.admins",
            _("bow.config.bow.admins.description"),
            null, String.class, false, false);

    public String key;
    public String description;
    public String defaultValue;
    public Class<?> type;
    public boolean isTransient;
    public boolean isFinal;

    BowConfigOption(String key, String description, String defaultValue,
            Class<?> type, boolean isTransient, boolean isFinal) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isFinal = isFinal;
        this.isTransient = isTransient;
    }

    @Override
    public boolean isFinal() {
        return isFinal;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    @Override
    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }
}