/*
 * #%L
 * bow
 * 
 * $Id: BowConfig.java 285 2011-05-16 13:21:52Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/BowConfig.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import static org.nuiton.i18n.I18n._;

import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfigOption;

/**
 *
 * @author poussin
 * @version $Revision: 285 $
 *
 * Last update: $Date: 2011-05-16 15:21:52 +0200 (lun., 16 mai 2011) $
 * by : $Author: sletellier $
 */
public class BowConfig {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(BowConfig.class);
    /** Singleton instance. */
    protected static ApplicationConfig config;

    private BowConfig() {
    }

    public static ApplicationConfig getConfig(String... args) {
        if (config == null) {
            synchronized (BowConfig.class) {
                if (config == null) {
                    try {
                        config = new ApplicationConfig(BowConfigOption.CONFIG_FILE.getDefaultValue());

                        // Load wikitty options
                        config.loadDefaultOptions(WikittyConfigOption.class);

                        // Load bow options
                        config.loadDefaultOptions(BowConfigOption.class);

                        // Parse args
                        config.parse(args);
                    } catch (Exception e) {
                        throw new UnhandledException(e);
                    }
                }
            }
        }
        return config;
    }

    /**
     * Get version as string.
     * Default bow applicationConfig will be used
     *
     * @return version
     */
    public static String getVersion() {
        return getVersion(getConfig());
    }

    /**
     * Get version as string.
     *
     * @param config bow configuration
     * @return version
     */
    public static String getVersion(ApplicationConfig config) {
        return config.getOption(BowConfigOption.APPLICATION_VERSION.key);
    }

    /**
     * Get bow url as string.
     * Default bow applicationConfig will be used
     *
     * @return url
     */
    public static String getBowUrl() {
        return getBowUrl(getConfig());
    }

    /**
     * Get bow url as string.
     *
     * @param config bow configuration
     * @return url
     */
    public static String getBowUrl(ApplicationConfig config) {
        String result = config.getOption(BowConfigOption.BOW_URL.key);
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    /**
     * Get alias url as string.
     * Default bow applicationConfig will be used
     *
     * @return url
     */
    public static String getAliasUrl() {
        return getAliasUrl(getConfig());
    }

    /**
     * Get alias url as string.
     *
     * @param config bow configuration
     * @return url
     */
    public static String getAliasUrl(ApplicationConfig config) {
        String result = config.getOption(BowConfigOption.ALIAS_URL.key);
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    /**
     * Get bow servlet as string.
     * Default bow applicationConfig will be used
     *
     * @return servlet name
     */
    public static String getServletBow() {
        return getServletBow(getConfig());
    }

    /**
     * Get bow servlet as string.
     *
     * @param config bow configuration
     * @return servlet name
     */
    public static String getServletBow(ApplicationConfig config) {
        return config.getOption(BowConfigOption.SERVLET_BOW.key);
    }

    /**
     * Get alias servlet as string.
     * Default bow applicationConfig will be used
     *
     * @return servlet name
     */
    public static String getServletAlias() {
        return getServletAlias(getConfig());
    }

    /**
     * Get alias servlet as string.
     *
     * @param config bow configuration
     * @return servlet name
     */
    public static String getServletAlias(ApplicationConfig config) {
        return config.getOption(BowConfigOption.SERVLET_ALIAS.key);
    }

    /**
     * Get alias servlet url as string.
     * Default bow applicationConfig will be used
     *
     * @return servlet name
     */
    public static String getServletAliasUrl() {
        return getServletAliasUrl(getConfig());
    }

    /**
     * Get alias servlet url as string.
     *
     * @param config bow configuration
     * @return servlet name
     */
    public static String getServletAliasUrl(ApplicationConfig config) {
        String result = getAliasUrl(config) + getServletAlias(config);
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    /**
     * Get bow smtp server as string.
     * Default bow applicationConfig will be used
     *
     * @return smtpServer
     */
    public static String getSmtpServer() {
        return getSmtpServer(getConfig());
    }

    /**
     * Get bow smtp server as string.
     *
     * @param config bow configuration
     * @return smtpServer
     */
    public static String getSmtpServer(ApplicationConfig config) {
        return config.getOption(BowConfigOption.BOW_SMTPSERVER.key);
    }

    /**
     * Get default search engine
     * Default bow applicationConfig will be used
     *
     * @return search engine url
     */
    public static String getSearchEngine() {
        return getSearchEngine(getConfig());
    }

    /**
     * Get default search engine
     *
     * @param config bow configuration
     * @return search engine url
     */
    public static String getSearchEngine(ApplicationConfig config) {
        return config.getOption(BowConfigOption.SEARCH_ENGINE.key);
    }

    /**
     * Get bow address from as string.
     * Default bow applicationConfig will be used
     *
     * @return addressFrom
     */
    public static String getAddressFrom() {
        return getAddressFrom(getConfig());
    }

    /**
     * Get bow address from as string.
     *
     * @param config bow configuration
     * @return addressFrom
     */
    public static String getAddressFrom(ApplicationConfig config) {
        return config.getOption(BowConfigOption.BOW_ADDRESSFROM.key);
    }

    /**
     * Get admins accounts
     * Default bow applicationConfig will be used
     *
     * @return admins
     */
    public static String[] getAdmins() {
        return getAdmins(getConfig());
    }

    /**
     * Get admins accounts
     *
     * @param config bow configuration
     * @return admins
     */
    public static String[] getAdmins(ApplicationConfig config) {
        String str = config.getOption(BowConfigOption.BOW_ADMINS.key);
        return StringUtil.split(str, ",");
    }

    /**
     * Return password for specified admin email
     * Default bow applicationConfig will be used
     *
     * @param admin emails account
     * @return null or password if available
     */
    public static String getAdminPassword(String admin) {
        return getAdminPassword(getConfig(), admin);
    }

    /**
     * Return password for specified admin email
     *
     * @param config bow configuration
     * @param admin emails account
     * @return null or password if available
     */
    public static String getAdminPassword(ApplicationConfig config, String admin) {
        return config.getOption(BowConfigOption.BOW_ADMINS.key + ".password." + admin);
    }

}
