package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelAbstract;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class BowBookmarkAbstract extends BusinessEntityImpl implements BowBookmark {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionBowBookmark;
    /**
     * getLink :
     * @return String 
     */

    @Override
    public String getLink() {
        String value = BowBookmarkHelper.getLink(getWikitty());
        return value;
}

    /**
     * setLink :
     * @param link 
     */

    @Override
    public void setLink(String link) {
        String oldValue = getLink();
        BowBookmarkHelper.setLink(getWikitty(), link);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_LINK, oldValue, getLink());
}

    /**
     * getDescription :
     * @return String 
     */

    @Override
    public String getDescription() {
        String value = BowBookmarkHelper.getDescription(getWikitty());
        return value;
}

    /**
     * setDescription :
     * @param description 
     */

    @Override
    public void setDescription(String description) {
        String oldValue = getDescription();
        BowBookmarkHelper.setDescription(getWikitty(), description);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION, oldValue, getDescription());
}

    /**
     * getCreationDate :
     * @return Date 
     */

    @Override
    public Date getCreationDate() {
        Date value = BowBookmarkHelper.getCreationDate(getWikitty());
        return value;
}

    /**
     * setCreationDate :
     * @param creationDate 
     */

    @Override
    public void setCreationDate(Date creationDate) {
        Date oldValue = getCreationDate();
        BowBookmarkHelper.setCreationDate(getWikitty(), creationDate);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE, oldValue, getCreationDate());
}

    /**
     * getClick :
     * @return int 
     */

    @Override
    public int getClick() {
        int value = BowBookmarkHelper.getClick(getWikitty());
        return value;
}

    /**
     * setClick :
     * @param click 
     */

    @Override
    public void setClick(int click) {
        int oldValue = getClick();
        BowBookmarkHelper.setClick(getWikitty(), click);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_CLICK, oldValue, getClick());
}

    /**
     * getPrivateAlias :
     * @return String 
     */

    @Override
    public String getPrivateAlias() {
        String value = BowBookmarkHelper.getPrivateAlias(getWikitty());
        return value;
}

    /**
     * setPrivateAlias :
     * @param privateAlias 
     */

    @Override
    public void setPrivateAlias(String privateAlias) {
        String oldValue = getPrivateAlias();
        BowBookmarkHelper.setPrivateAlias(getWikitty(), privateAlias);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS, oldValue, getPrivateAlias());
}

    /**
     * getPublicAlias :
     * @return String 
     */

    @Override
    public String getPublicAlias() {
        String value = BowBookmarkHelper.getPublicAlias(getWikitty());
        return value;
}

    /**
     * setPublicAlias :
     * @param publicAlias 
     */

    @Override
    public void setPublicAlias(String publicAlias) {
        String oldValue = getPublicAlias();
        BowBookmarkHelper.setPublicAlias(getWikitty(), publicAlias);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS, oldValue, getPublicAlias());
}

    /**
     * getBowUser :
     * @return String 
     */

    @Override
    public String getBowUser() {
        String value = BowBookmarkHelper.getBowUser(getWikitty());
        return value;
}

    /**
     * setBowUser :
     * @param bowUser 
     */

    @Override
    public void setBowUser(String bowUser) {
        String oldValue = getBowUser();
        BowBookmarkHelper.setBowUser(getWikitty(), bowUser);
        getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_BOWUSER, oldValue, getBowUser());
}

    /**
     * getLabels :
     * @return Set<String> 
     */

    public Set<String> getLabels() {
        Set<String> result = WikittyLabelHelper.getLabels(getWikitty());
        return result;
}

    /**
     * setLabels :
     * @param labels 
     */

    public void setLabels(Set<String> labels) {
        Set<String> oldValue = getLabels();
        WikittyLabelHelper.setLabels(getWikitty(), labels);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    /**
     * addAllLabels :
     * @param labels 
     */

    public void addAllLabels(Set<String> labels) {
        Set<String> oldValue = getLabels();
        WikittyLabelHelper.addAllLabels(getWikitty(), labels);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    /**
     * addLabels :
     * @param element 
     */

    public void addLabels(String element) {
        WikittyLabelHelper.addLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * removeLabels :
     * @param element 
     */

    public void removeLabels(String element) {
        WikittyLabelHelper.removeLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * clearLabels :
     */

    public void clearLabels() {
        WikittyLabelHelper.clearLabels(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * BowBookmarkAbstract :
     */

    public BowBookmarkAbstract() {
        super();
}

    /**
     * BowBookmarkAbstract :
     * @param wikitty 
     */

    public BowBookmarkAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * BowBookmarkAbstract :
     * @param businessEntityImpl 
     */

    public BowBookmarkAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionBowBookmark =
                new WikittyExtension(EXT_BOWBOOKMARK,
                                     "2.0", // version
                                     WikittyLabel.EXT_WIKITTYLABEL,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String link unique=\"true\"", 
                                             "String description unique=\"true\"", 
                                             "Date creationDate unique=\"true\"", 
                                             "Numeric click unique=\"true\"", 
                                             "String privateAlias unique=\"true\"", 
                                             "String publicAlias unique=\"true\"", 
                                             "Wikitty bowUser unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyLabelAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBowBookmark);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //BowBookmarkAbstract
