/*
 * #%L
 * bow
 * 
 * $Id: BookmarkActions.java 283 2011-05-12 14:29:07Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.0/bow-ui/src/main/java/org/chorem/bow/BookmarkActions.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.FacetTopic;

/**
 *
 * @author bbrossaud
 */
public class BookmarkActions {

    protected String fullTextLine = "";
    protected List<BowBookmark> bookmarks = new ArrayList<BowBookmark>(); // bookmarks which contain the search tags
    protected List<BowBookmark> lastBookmarks = new ArrayList<BowBookmark>();
    protected List<FacetTopic> tagsCloud = new ArrayList<FacetTopic>(); // associate a tag with its frequency
    protected List<String> tagsSearch = new ArrayList<String>(); // contains the tags taped in the search field
    protected int tmax = -1;
    protected int tmin = -1;

    
    public void createTagCloud(List<FacetTopic> cpy) {
        setTagCloud(cpy);
        deleteTagBySearch();
        defineTValues();
    }

    public void setTagCloud(List<FacetTopic> cpy) {
        if (cpy != null) {
            tagsCloud = new ArrayList<FacetTopic>(cpy);
        }
    }

    public void deleteTagBySearch() {
        List<FacetTopic> save = new ArrayList<FacetTopic>(tagsCloud);
        for (FacetTopic topic : save) {
            String name = topic.getTopicName();
            if (tagsSearch.contains(name)) {
                tagsCloud.remove(topic);
            }
        }
    }

    protected void defineTValues() {
        tmax = -1; // correspond to the most tag frequency in the tag cloud
        tmin = -1; // correspond to the less tag frequency in the tag cloud
        for (FacetTopic tag : tagsCloud) {
            int value = tag.getCount();
            if (tmax < value) { // search the most tag frequancy
                tmax = value;
            }
            if (tmin == -1) {
                tmin = value;
            } else if (tmin > value) { // search less tag frequency
                tmin = value;
            }
        }
    }

    public void addTags(String str) {
        if (str != null) {
            if (!str.isEmpty()) {
                str = str.trim();
                String[] tags = str.split("\\s+");
                for (String tag : tags) {
                    if (!tagsSearch.contains(tag)) {
                        tagsSearch.add(tag);
                    }
                }
            }
        }
    }

    public void emptySearchline() {
        List<BowBookmark> bookmarkList = new ArrayList<BowBookmark>(bookmarks);
        for (BowBookmark bookmark : bookmarkList) {
            Set<String> tags = bookmark.getLabels();
            if (tags != null && !tags.isEmpty()) {
                bookmarks.remove(bookmark);
            }
        }
    }

    public void reset() {
        bookmarks.clear();
        tagsCloud.clear();
        tagsSearch.clear();
        tmax = -1;
        tmin = -1;
    }

    public void setFullTextLine(String line) {
        if (line == null) {
            fullTextLine = "";
        } else {
            fullTextLine = line;
        }
    }

    public void setBookmarks(List<BowBookmark> bookmarksList) {
        List<BowBookmark> newList = new ArrayList<BowBookmark>(bookmarksList);
        bookmarks = newList;
    }

    public void setLastBookmarks(List<BowBookmark> bookmarksList) {
        List<BowBookmark> newList = new ArrayList<BowBookmark>(bookmarksList);
        lastBookmarks = newList;
    }

    public void setTagSearch(List<String> cpy) {
        tagsSearch = cpy;
    }

    public String getSearchLine() {
        if (tagsSearch != null) {
            return StringUtil.join(tagsSearch, " ", true); // return the search line created with the tags
        }
        return StringUtils.EMPTY;
    }

    public int getFont(int ti) {
        int font = 1;
        if (tmax > tmin) {
            font = 30 * (ti - tmin) / (tmax - tmin); // get the font size for a tag frequency
        }
        if (font < 10) {
            font = 10;
        }
        return font;
    }

    public List<FacetTopic> getTagsCloud() {
        return tagsCloud;
    }

    public List<String> getTagsSearch() {
        return tagsSearch;
    }

    public List<BowBookmark> getBookmarks() {
        return bookmarks;
    }

    public List<BowBookmark> getLastBookmarks() {
        return lastBookmarks;
    }

    public int getTmin() {
        return tmin;
    }

    public int getTmax() {
        return tmax;
    }

    public String getFullTextLine() {
        if (fullTextLine == null) {
            return StringUtils.EMPTY;
        }
        return fullTextLine;
    }
}
