/*
 * #%L
 * bow
 * 
 * $Id: OrderAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.5/bow-ui/src/main/java/org/chorem/bow/action/OrderAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BookmarkActions;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowPreference;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.WikittyProxy;

import static org.nuiton.i18n.I18n.n_;

/**
 * Permet de modifie l'ordre de tri des bookmarks
 * TODO poussin 20110211 cette action n'est pas vraiment pertinente et devrait
 * etre des options de l'action de recherche
 *
 * @author poussin
 */
public class OrderAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 203690999710176818L;
    protected String type;
    protected String searchLine;
    protected HttpServletRequest request;
    
    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }

    /**
     * Orders the bookmarks according to a criteria
     */
    public String execute() {
        try {
            BowPreference user = getBowSession().getPreference();
            Criteria baseCriteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, searchLine);

            if (type != null && baseCriteria != null && !type.isEmpty()) {
                WikittyProxy proxy = getBowProxy();
                PagedResult<BowBookmark> result = null;

                if (type.equals("ascName")) {
                    Criteria criteria = baseCriteria.addSortAscending(
                            BowBookmark.FQ_FIELD_BOWBOOKMARK_DESCRIPTION);
                    result = proxy.findAllByCriteria(BowBookmark.class, criteria);
                    addActionMessage(getText(n_("bow.search.order.ascName")));
                } else if (type.equals("ascDate")) {
                    Criteria criteria = baseCriteria.addSortAscending(
                            BowBookmark.FQ_FIELD_BOWBOOKMARK_CREATIONDATE);
                    result = proxy.findAllByCriteria(BowBookmark.class, criteria);
                    addActionMessage(getText(n_("bow.search.order.ascDate")));
                } else if (type.equals("ascClick")) {
                    Criteria criteria = baseCriteria.addSortAscending(
                            BowBookmark.FQ_FIELD_BOWBOOKMARK_CLICK);
                    result = proxy.findAllByCriteria(BowBookmark.class, criteria);
                    addActionMessage(getText(n_("bow.search.order.ascClick")));
                } else if (type.equals("descName")) {
                    Criteria criteria = baseCriteria.addSortDescending(
                            BowBookmark.FQ_FIELD_BOWBOOKMARK_DESCRIPTION);
                    result = proxy.findAllByCriteria(BowBookmark.class, criteria);
                    addActionMessage(getText(n_("bow.search.order.descName")));
                } else if (type.equals("descDate")) {
                    Criteria criteria = baseCriteria.addSortDescending(
                            BowBookmark.FQ_FIELD_BOWBOOKMARK_CREATIONDATE);
                    result = proxy.findAllByCriteria(BowBookmark.class, criteria);
                    addActionMessage(getText(n_("bow.search.order.descDate")));
                } else if (type.equals("descClick")) {
                    Criteria criteria = baseCriteria.addSortDescending(
                            BowBookmark.FQ_FIELD_BOWBOOKMARK_CLICK);
                    result = proxy.findAllByCriteria(BowBookmark.class, criteria);
                    addActionMessage(getText(n_("bow.search.order.descClick")));
                }
                BookmarkActions bookmarkActions =
                    BookmarkUtils.createBookmarkActions(request, result, searchLine);
                request.setAttribute("bookmarkActions", bookmarkActions);
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
    }
}
