/*
 * #%L
 * BOW UI
 * 
 * $Id: Migrate04To05Action.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.5/bow-ui/src/main/java/org/chorem/bow/action/Migrate04To05Action.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowMigration04To05;
import org.chorem.bow.BowSession;
import org.nuiton.wikitty.WikittyProxy;

import static org.nuiton.i18n.I18n.n_;

/**
 * Lance la migration des données de la version 0.4 vers 0.5
 *
 * @author poussin
 * @version $Revision: 228 $
 *
 * Last update: $Date: 2011-03-03 11:59:29 +0100 (jeu., 03 mars 2011) $
 * by : $Author: vbriand $
 */
public class Migrate04To05Action extends BowBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(Migrate04To05Action.class);

    public String execute() {
        try {
            BowSession session = getBowSession();
            if (session.isAdmin()) { //If is admin
                WikittyProxy proxy = getBowProxy();
                
                BowMigration04To05.migrate(proxy);
                addActionMessage(getText(n_("bow.admin.dataMigration.success")));
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
    }

}
