/*
 * #%L
 * bow
 * 
 * $Id: LoginAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.5/bow-ui/src/main/java/org/chorem/bow/action/LoginAction.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.bow.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowInit;
import org.chorem.bow.BowPreference;
import org.chorem.bow.BowUserImpl;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * authentifie l'utilisateur et place son objet User dans la bow session
 * 
 * @author poussin
 */
public class LoginAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 6891064800288772246L;
    protected String email;
    protected String password;
    protected HttpServletRequest servletRequest;

    public String getEmail() {
	return email;
    }
    
    public void setEmail(String email) {
	this.email = email;
    }
    
    public String getPassword() {
	return password;
    }
    
    public void setPassword(String password) {
	this.password = password;
    }
    
    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.servletRequest = request;
    }

    /**
     * Check password in solr index, if fail try to check password admin in config file
     *
     * @param email
     * @param password
     * @return
     */
    protected BowUser checkLogin(String email, String password) {
        BowUser result = null;
        if (email != null && password != null) {
            if (!email.isEmpty() && !password.equals(StringUtil.encodeMD5(""))) {
                WikittyProxy proxy = getBowProxy();
                Criteria criteria = Search.query().eq(BowUser.FQ_FIELD_WIKITTYUSER_LOGIN, email).
                        eq(BowUser.FQ_FIELD_WIKITTYUSER_PASSWORD, password).criteria();
                result = proxy.findByCriteria(BowUser.class, criteria);

                if (result == null) {
                    // failback: try to authenticate admin with config info
                    String configPassword = BowConfig.getInstance().getAdminPassword(email);
                    log.info("failback password: " + password + " configPassword: " + configPassword);
                    if (password.equals(configPassword)) {
                        // admin authenticate with config, this is possible when
                        // solr index is corrupted or missed. Admin must go to admin
                        // page en recreate index
                        result = new BowUserImpl();
                        result.setLogin(email);
                        result.setPassword(configPassword);
                        addActionMessage(getText(n_("bow.login.admin.failback")));
                        log.warn(getText(n_("bow.login.admin.failback")));
                    } else {
                        addActionError(getText(n_("bow.login.authenticationFailure")));
                    }
                }
            }
        }
        return result;
    }
    
    /**
     * Authenticates the user if his email and password are valid 
     */
    public String execute() {
        String result = INPUT;

        try {
            if (email != null) {
                email = email.trim();

                if (password != null) {
                    String md5 = StringUtil.encodeMD5(password);
                    BowUser user;

                    user = checkLogin(email, md5);
                    if (user != null) {
                        getBowSession().setUser(user);
                        BowPreference pref = getBowSession().getPreference();
                        BowInit.initHomePage(servletRequest, pref);
                        result = SUCCESS;
                    }
                }
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return result;
    }
}