/*
 * #%L
 * bow
 * 
 * $Id: ImportBookmarksAction.java 232 2011-03-10 11:29:17Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.5/bow-ui/src/main/java/org/chorem/bow/action/ImportBookmarksAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.*;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;

import static org.nuiton.i18n.I18n.n_;

/**
 * Import un bookmark HTML
 * 
 * @author poussin
 */
public class ImportBookmarksAction extends BowBaseAction implements
        ServletRequestAware {

    private static final long serialVersionUID = -5962680416570797028L;

    protected File upfile;
    protected String upfileContentType;
    protected String upfileFileName;
    protected String searchLine;
    protected String fullTextLine;
    protected String redirectTo;
    protected HttpServletRequest request;

    /**
     * @return the upfile
     */
    public File getUpfile() {
        return upfile;
    }

    /**
     * @param upfile
     *            the upfile to set
     */
    public void setUpfile(File upfile) {
        this.upfile = upfile;
    }

    /**
     * @return the upfileContentType
     */
    public String getUpfileContentType() {
        return upfileContentType;
    }

    /**
     * @param upfileContentType
     *            the upfileContentType to set
     */
    public void setUpfileContentType(String upfileContentType) {
        this.upfileContentType = upfileContentType;
    }

    /**
     * @return the upfileFileName
     */
    public String getUpfileFileName() {
        return upfileFileName;
    }

    /**
     * @param upfileFileName
     *            the upfileFileName to set
     */
    public void setUpfileFileName(String upfileFileName) {
        this.upfileFileName = upfileFileName;
    }

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine
     *            the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine
     *            the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    /**
     * @return the redirectTo
     */
    public String getRedirectTo() {
        return redirectTo;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    protected void parseHtmlToBookmarks(NodeList list, BowUser user, Date date,
            List<BowBookmark> bookmarks, List<String> tagList)
            throws ParserException {

        boolean isFolder = false;
        SimpleNodeIterator it = list.elements();

        while (it.hasMoreNodes()) {
            Node node = it.nextNode();
            String plainText = node.toPlainTextString(); // The text between
                                                         // two heads ==>
                                                         // <toto>plainText</toto>
            String text = node.getText(); // The text in the head ==>
                                          // <text></toto>

            if (text != null && text.startsWith("H3")) { // H3 = folder
                if (plainText != null && !plainText.isEmpty()) {
                    tagList.add(plainText); // Adds the folder name to the
                                            // tagList
                    isFolder = true;
                }
            } else if (text != null && text.startsWith("A HREF")) { // HREF
                                                                    // = new
                                                                    // bookmarks
                BowBookmark bookmark = BookmarkUtils
                        .createBookmarkFromHtml(text, plainText, user);
                Wikitty w = getBowProxy().getWikitty(bookmark);
                BowImportHelper.addExtension(w);
                BowImportHelper.setImportDate(w, date);
                BookmarkUtils.addTagsToBookmark(tagList, bookmark);

                bookmarks.add(bookmark);
            }
            NodeList children = node.getChildren();

            if (children != null) {
                parseHtmlToBookmarks(children, user, date, bookmarks,
                        tagList); // If there is an under node = recursion
            }
        }
        if (isFolder) { // If we find a folder, we have to remove it
            int index = tagList.size() - 1;

            if (index > -1) {
                tagList.remove(index);
            }
        }
    }

    public String execute() {

        log.info("Importing boormarks : " + upfile);
        try {
            BowPreference user = getBowSession().getPreference();

            // Struts limite to html files, is null if not one
            if (upfile != null) {
                WikittyProxy proxy = getBowProxy();

                try {
                    URL url = upfile.toURI().toURL();
                    Parser parser = new Parser(url.openConnection());
                    NodeList list = parser.parse(null);

                    List<BowBookmark> bookmarks = new ArrayList<BowBookmark>();
                    parseHtmlToBookmarks(list, user, new Date(), bookmarks,
                            new ArrayList<String>());
                    proxy.store(bookmarks);

                    redirectTo = BowUtils.redirectTo(searchLine, fullTextLine);
                    if (StringUtils.isEmpty(searchLine)) {
                        BowInit.initHomePage(request, user);
                    } else {
                        BowSearch.search(request, user);
                    }
                    addActionMessage(getText(n_("bow.bookmark.import.successful")));
                } catch (ParserException e) {
                    addActionError(getText(n_("bow.bookmark.badFileFormat")));

                    if (searchLine == null || searchLine.isEmpty()) {
                        BowInit.initHomePage(request, user);
                    } else {
                        BowSearch.search(request, user);
                    }
                } catch (IOException e2) {
                    addActionError(getText(n_("bow.error.internal")));
                    log.error(e2.getMessage(), e2);
                    return ERROR;
                }
            } else {
                addActionError(getText(n_("bow.bookmark.badFileFormat")));
                return ERROR;
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
            return ERROR;
        }
        return SUCCESS;
    }
}
