/*
 * #%L
 * bow
 * 
 * $Id: ForgotPasswordAction.java 228 2011-03-03 10:59:29Z vbriand $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.5/bow-ui/src/main/java/org/chorem/bow/action/ForgotPasswordAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

import org.apache.commons.lang.RandomStringUtils;
import org.chorem.bow.BowMail;
import org.chorem.bow.BowUser;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * Genere un nouveau mot de passe pour l'utilisateur et lui envoie par mail
 * TODO poussin 20110211 il faudrait ajouter une securite pour eviter que
 * quelqu'un s'amuse a demander la modification de password de quelqu'un d'autre
 * toutes les 2s
 * - soit en ne permettant l'envoi qu'une fois par jour
 * - soit ????
 *
 * @author poussin
 */
public class ForgotPasswordAction extends BowBaseAction {
    private static final long serialVersionUID = -8207951465957204954L;
    protected String email;

    /**
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * @param email the email to set
     */
    public void setEmail(String email) {
        this.email = email;
    }
    
//    protected boolean passwordExists(String password) {
//        WikittyProxy proxy = getBowProxy();
//        Criteria criteria = Search.query().eq(User.FQ_FIELD_USER_PASSWORD, password).criteria();
//        List<User> users = proxy.findAllByCriteria(User.class, criteria).getAll();
//        if (users != null && users.size() > 0) {
//            return true;
//        }
//        return false;
//    }

    /**
     * Generates a new password and sends it to the user
     */
    public String execute() {
        String result = INPUT;

        try {
            if (email != null) {
                email = email.trim();
                if (!email.isEmpty()) {
                    WikittyProxy proxy = getBowProxy();
                    Criteria criteria = Search.query()
                    .eq(BowUser.FQ_FIELD_WIKITTYUSER_LOGIN, email).criteria();
                    BowUser user = proxy.findByCriteria(BowUser.class, criteria);

                    if (user != null) { //If the email address exists
                        String password = "";
                        String md5 = "";

                        password = RandomStringUtils.randomAlphanumeric(20);
                        md5 = StringUtil.encodeMD5(password);
                        try {
                            String mailContent;

                            mailContent = getText(n_("bow.register.mailHi")) +
                            ",\n\n" + getText(n_("bow.register.mailPwd")) + ": " + 
                            password + "\n\n" + getText(n_("bow.register.mailEmail")) + 
                            ": " + email + "\n\n";
                            BowMail.sendMail(email,
                                    getText(n_("bow.register.mailSubject")),
                                    mailContent);

                            //The password is changed only if the mail has been sent
                            user.setPassword(md5);
                            proxy.store(user);
                        } catch (AddressException e) {
                            //If the email address is invalid
                            String message = getText("bow.mail.badFormat");

                            addActionError(n_(message));
                            log.error(message + " (email:" + email + ")", e);
                        } catch (MessagingException e) {
                            String message = getText("bow.mail.sendError");

                            addActionError(n_(message));
                            log.error(message + "(" + e.getMessage() + ")", e);
                        }
                        result = SUCCESS;
                    } else { //If the email is not associated with an account
                        addFieldError("email",
                                getText(n_("bow.forgotPassword.emailDoesntExist")));
                    }
                }
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return result;
    }
}