/*
 * #%L
 * BOW UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowBookmarkImpl;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;

import static org.nuiton.i18n.I18n.n_;

/**
 * Load a bookmark to display it on modification page, used when javascript
 * is not available on client
 *
 * @author sletellier
 */
public class EditBookmarkAction extends BowBaseAction {

    protected String id;
    protected BowBookmark bookmark;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BowBookmark getBookmark() {
        if (bookmark == null) {
            bookmark = new BowBookmarkImpl();
        }
        return bookmark;
    }

    @Override
    public String execute() throws Exception {
        if (id == null) {
            return SUCCESS;
        }
        try {
            WikittyProxy proxy = getBowProxy();
            Criteria criteria = Search.query()
            .eq(Element.ELT_ID, id).criteria();
            bookmark = proxy.findByCriteria(BowBookmark.class, criteria);
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
    }
}
