/*
 * #%L
 * bow
 * 
 * $Id: DeleteImportAction.java 232 2011-03-10 11:29:17Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.5/bow-ui/src/main/java/org/chorem/bow/action/DeleteImportAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.util.List;

import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowImport;
import org.chorem.bow.BowUser;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * Supprime un import de bookmark
 *
 * @author poussin
 */
public class DeleteImportAction extends BowBaseAction {
    private static final long serialVersionUID = 8714394293884265516L;
    protected String date;
    
    /**
     * @return the date
     */
    public String getDate() {
        return date;
    }
    /**
     * @param date the date to set
     */
    public void setDate(String date) {
        this.date = date;
    }
    
    /**
     * Deletes a bookmark import
     */
    public String execute() {
        try {
            if (date != null &&
                    date.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{1,3}Z")) {
                WikittyProxy proxy = getBowProxy();
                BowUser user = getBowSession().getUser();
                Criteria criteria = Search.query()
                .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_BOWUSER, user.getWikittyId())
                .eq(BowImport.FQ_FIELD_BOWIMPORT_IMPORTDATE, date).criteria();
                List<BowImport> bookmarks = proxy.findAllByCriteria(BowImport.class, criteria).getAll();

                if (log.isDebugEnabled()) {
                    log.debug("Will delete " + bookmarks.size() + " bookmarks");
                }

                proxy.delete(bookmarks);

                addActionMessage(getText(n_("bow.bookmark.import.delete.successful")));
            }
        } catch (Exception e) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(e.getMessage(), e);
        }
        return SUCCESS;
    }

}