/*
 * #%L
 * BOW UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowBookmark;
import static org.nuiton.i18n.I18n.n_;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

/**
 * Handles only public aliases. Private aliases are handled by open search.
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public class AliasAction extends BowBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(AliasAction.class);

    protected String redirectTo = "/";
    protected String alias;
    protected String bookmarkId;

    public String getRedirectTo() {
        return redirectTo;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    @Override
    public String execute() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Redirect alias " + alias);
        }
        String result = SUCCESS;
        try {
            if (!StringUtils.isEmpty(alias)) {
                WikittyProxy proxy = getBowProxy();
                
                Criteria criteria = Search.query().eq(
                        BowBookmark.FQ_FIELD_BOWBOOKMARK_PUBLICALIAS, alias).criteria();
                
                BowBookmark bookmark = proxy.findByCriteria(BowBookmark.class, criteria);
                if (bookmark == null) {
                    bookmark = proxy.restore(BowBookmark.class, alias);
                }
                if (bookmark != null) {
                    redirectTo = bookmark.getLink();
                    int clicks = bookmark.getClick() + 1;
                    bookmark.setClick(clicks);
                    proxy.store(bookmark);
                } else {
                    log.debug(getText(n_("bow.alias.bookmarkId.unknown"), new String[]{alias}));
                    addActionError(getText(n_("bow.alias.bookmarkId.unknown"), new String[]{alias}));
                    log.debug("No bookmark with alias or id " + alias);
                    result = ERROR;
                }
            }
        } catch (Exception eee) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(eee.getMessage(), eee);
            result = ERROR;
        }
        return result;
    }

    public String create() throws Exception {
        String result = SUCCESS;
        try {
            if (!StringUtils.isEmpty(alias)) {
                WikittyProxy proxy = getBowProxy();

                Criteria criteria = Search.query().eq(
                        BowBookmark.FQ_FIELD_BOWBOOKMARK_PUBLICALIAS, alias).criteria();

                BowBookmark bookmark = proxy.findByCriteria(BowBookmark.class, criteria);
                if (bookmark != null) {
                    addActionError(getText(n_("bow.alias.already.exists"), new String[]{alias}));
                    log.error("A bookmark already exists with alias " + alias);
                    result = ERROR;
                    
                } else {
                    bookmark = proxy.restore(BowBookmark.class, bookmarkId);
                    if (bookmark != null) {
                        bookmark.setPublicAlias(alias);
                        proxy.store(bookmark);
                    } else {
                        addActionError(getText(n_("bow.alias.bookmarkId.unknown"), new String[]{bookmarkId}));
                        log.debug("No bookmark with id " + bookmarkId);
                        result = ERROR;
                    }
                }
            }
        } catch (Exception eee) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(eee.getMessage(), eee);
            result = ERROR;
        }

        return result;
    }

    public String delete() throws Exception {
        log.debug("delete alias for id " + bookmarkId);
        String result = SUCCESS;
        try {
            WikittyProxy proxy = getBowProxy();

            BowBookmark bookmark = proxy.restore(BowBookmark.class, bookmarkId);
            if (bookmark != null) {
                bookmark.setPublicAlias(null);
                proxy.store(bookmark);
            } else {
                addActionError(getText(n_("bow.alias.bookmarkId.unknown"), new String[]{bookmarkId}));
                log.error("No bookmark with id " + bookmarkId);
                result = ERROR;
            }
        } catch (Exception eee) {
            addActionError(getText(n_("bow.error.internal")));
            log.error(eee.getMessage(), eee);
            result = ERROR;
        }

        return result;
    }

}
