package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class PreferenceHelper {

    /**
     * PreferenceHelper :
     * utility class all provided methods are accessible the static way
     */

    private PreferenceHelper() {// empty
}

    /**
     * getTags :
     * @param wikitty 
     * @return int 
     */

    public static int getTags(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_TAGS);
        return value;
}

    /**
     * setTags :
     * @param wikitty 
     * @param tags 
     * @return int 
     */

    public static int setTags(Wikitty wikitty, int tags) {
        int oldValue = getTags(wikitty);
        wikitty.setField(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_TAGS, tags);
        return oldValue;
}

    /**
     * getBookmarks :
     * @param wikitty 
     * @return int 
     */

    public static int getBookmarks(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_BOOKMARKS);
        return value;
}

    /**
     * setBookmarks :
     * @param wikitty 
     * @param bookmarks 
     * @return int 
     */

    public static int setBookmarks(Wikitty wikitty, int bookmarks) {
        int oldValue = getBookmarks(wikitty);
        wikitty.setField(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_BOOKMARKS, bookmarks);
        return oldValue;
}

    /**
     * getColors :
     * @param wikitty 
     * @return String 
     */

    public static String getColors(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_COLORS);
        return value;
}

    /**
     * setColors :
     * @param wikitty 
     * @param colors 
     * @return String 
     */

    public static String setColors(Wikitty wikitty, String colors) {
        String oldValue = getColors(wikitty);
        wikitty.setField(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_COLORS, colors);
        return oldValue;
}

    /**
     * getSearchEngineUrlSuggestions :
     * @param wikitty 
     * @return String 
     */

    public static String getSearchEngineUrlSuggestions(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLSUGGESTIONS);
        return value;
}

    /**
     * setSearchEngineUrlSuggestions :
     * @param wikitty 
     * @param searchEngineUrlSuggestions 
     * @return String 
     */

    public static String setSearchEngineUrlSuggestions(Wikitty wikitty, String searchEngineUrlSuggestions) {
        String oldValue = getSearchEngineUrlSuggestions(wikitty);
        wikitty.setField(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLSUGGESTIONS, searchEngineUrlSuggestions);
        return oldValue;
}

    /**
     * getSearchEngineUrlResults :
     * @param wikitty 
     * @return String 
     */

    public static String getSearchEngineUrlResults(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLRESULTS);
        return value;
}

    /**
     * setSearchEngineUrlResults :
     * @param wikitty 
     * @param searchEngineUrlResults 
     * @return String 
     */

    public static String setSearchEngineUrlResults(Wikitty wikitty, String searchEngineUrlResults) {
        String oldValue = getSearchEngineUrlResults(wikitty);
        wikitty.setField(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLRESULTS, searchEngineUrlResults);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_TAGS);
            Object f2 = w2.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_BOOKMARKS);
            Object f2 = w2.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_BOOKMARKS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_COLORS);
            Object f2 = w2.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_COLORS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLSUGGESTIONS);
            Object f2 = w2.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLSUGGESTIONS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLRESULTS);
            Object f2 = w2.getFieldAsObject(Preference.EXT_PREFERENCE, Preference.FIELD_PREFERENCE_SEARCHENGINEURLRESULTS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Preference.EXT_PREFERENCE);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : PreferenceAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //PreferenceHelper
