/*
 * #%L
 * bow
 * 
 * $Id: OpenSearchActions.java 206 2011-02-17 01:16:20Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.5/bow-ui/src/main/java/org/chorem/bow/OpenSearchActions.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuiton.wikitty.search.FacetTopic;

/**
 *
 * @author bbrossaud
 */
public class OpenSearchActions {

    protected List<BowBookmark> bookmarkList = new ArrayList<BowBookmark>();
    protected List<FacetTopic> suggestions = new ArrayList<FacetTopic>();
    protected String[] search;

    public void findSuggestions(List<String> searchLine) {
        int size = searchLine.size();
        search = searchLine.toArray(new String[size]);
        String word = search[size - 1];
        List<FacetTopic> save = new ArrayList<FacetTopic>(suggestions);
        for (FacetTopic topic : save) {
            String tag = topic.getTopicName();
            if (tag != null) {
                if (tag.indexOf(word) != 0 || searchLine.contains(tag)) {
                    suggestions.remove(topic);
                }
            }
        }
        List<BowBookmark> cpy = new ArrayList<BowBookmark>(bookmarkList);
        for (BowBookmark bookmark : cpy) {
            Set<String> tags = bookmark.getLabels();
            boolean delete = true;
            for (FacetTopic topic : suggestions) {
                String name = topic.getTopicName();
                if (tags != null && tags.contains(name)) {
                    delete = false;
                    break;
                }
            }
            if (delete) {
                bookmarkList.remove(bookmark);
            }
        }
        Collections.sort(suggestions, new SuggestionsComparator());
    }

    protected boolean bookmarkHasTag(BowBookmark bookmark, String tag) {
        Set<String> tagList = bookmark.getLabels();
        if (tagList != null) {
            if (tagList.contains(tag)) {
                return true;
            }
        }
        return false;
    }

    public void setBookmarkList(List<BowBookmark> bookmarks) {
        if (bookmarks != null) {
            List<BowBookmark> newList = new ArrayList<BowBookmark>(bookmarks);
            bookmarkList = newList;
        }
    }

    public String getJsonResult() {
        String str = "[";

        str += "\"" + StringUtils.join(search, ' ') + "\",";
        str += getJsonSuggestions();
        str += ",";
        str += getJsonDescription();
        str += "]";
        return str;
    }

    public String getJsonSuggestions() {
        String str = "[";
        String srch = "";
        Iterator<FacetTopic> it = suggestions.iterator();
        if (search.length > 1) {
            srch = StringUtils.join(search, ' ', 0, search.length - 1);
            srch += " ";
        }
        while (it.hasNext()) {
            FacetTopic su = it.next();
            str += "\"" + srch + su.getTopicName() + "\"";
            if (it.hasNext()) {
                str += ",";
            }
        }
        if (bookmarkList.size() <= 5 && suggestions.size() > 0) {
            for (BowBookmark bookmark : bookmarkList) {
                str += ",\"" + bookmark.getLink() + "\"";
            }
        }
        str += "]";
        return str;
    }

    public String getJsonDescription() {
        String str = "[";
        Iterator<FacetTopic> it = suggestions.iterator();
        while (it.hasNext()) {
            FacetTopic su = it.next();
            str += "\"" + su.getCount() + " results\"";
            if (it.hasNext()) {
                str += ",";
            }
        }
        str += "]";
        return str;
    }

    public void setSearch(String[] tab) {
        search = tab;
    }

    public void setSuggestionList(List<FacetTopic> list) {
        if (list != null) {
        suggestions = new ArrayList<FacetTopic>(list);
        }
    }

    public List<BowBookmark> getBookmarkList() {
        return bookmarkList;
    }

    public String[] getSearch() {
        return search;
    }

    public List<FacetTopic> getSuggestionList() {
        return suggestions;
    }
}
