/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.ToneGenerator;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import org.chorem.android.saymytexts.SMS;
import org.chorem.android.saymytexts.SayMyTextService;

public class DictateSmsBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "DictateSmsBroadcastReceiver";
    public static final String ACTION_DICTATE_SMS = "org.chorem.android.saymytexts.DICTATE_SMS";
    public static final String INTENT_EXTRA_SMS = "sms";
    public static final String INTENT_EXTRA_ATTEMPT_NUMBER = "attemptNumber";

    public void onReceive(final Context context, final Intent intent) {
        Log.d((String)TAG, (String)"next action ?");
        final SMS sms = (SMS)intent.getSerializableExtra(INTENT_EXTRA_SMS);
        if (sms != null) {
            SpeechRecognizer speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
            speechRecognizer.setRecognitionListener(new RecognitionListener(){
                private ToneGenerator tg = new ToneGenerator(0, 100);

                public void onReadyForSpeech(Bundle params) {
                }

                public void onBeginningOfSpeech() {
                }

                public void onRmsChanged(float rmsdB) {
                }

                public void onBufferReceived(byte[] buffer) {
                }

                public void onEndOfSpeech() {
                }

                public void onError(int error) {
                    Log.d((String)DictateSmsBroadcastReceiver.TAG, (String)("onError " + error));
                    this.tg.startTone(26);
                    DictateSmsBroadcastReceiver.this.reaskToDictate(context, intent, sms);
                }

                public void onResults(Bundle data) {
                    ArrayList results = data.getStringArrayList("results_recognition");
                    Log.d((String)DictateSmsBroadcastReceiver.TAG, (String)("results " + results));
                    if (results != null) {
                        String text = (String)results.get(0);
                        Intent serviceIntent = new Intent(context, SayMyTextService.class);
                        serviceIntent.setAction("org.chorem.android.saymytexts.CONFIRM_SMS_SENDING");
                        serviceIntent.putExtra(DictateSmsBroadcastReceiver.INTENT_EXTRA_SMS, (Serializable)sms);
                        serviceIntent.putExtra("dictatedMessage", text);
                        context.startService(serviceIntent);
                    } else {
                        this.tg.startTone(26);
                        DictateSmsBroadcastReceiver.this.reaskToDictate(context, intent, sms);
                    }
                }

                public void onPartialResults(Bundle partialResults) {
                }

                public void onEvent(int eventType, Bundle params) {
                }
            });
            Intent recognizeIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
            recognizeIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
            speechRecognizer.startListening(recognizeIntent);
        }
    }

    protected void reaskToDictate(Context context, Intent intent, SMS sms) {
        int attemptNumber = intent.getIntExtra(INTENT_EXTRA_ATTEMPT_NUMBER, 1);
        Intent serviceIntent = new Intent(context, SayMyTextService.class);
        serviceIntent.setAction(ACTION_DICTATE_SMS);
        serviceIntent.putExtra(INTENT_EXTRA_SMS, (Serializable)sms);
        serviceIntent.putExtra(INTENT_EXTRA_ATTEMPT_NUMBER, attemptNumber);
        context.startService(serviceIntent);
    }
}

