/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.android.saymytexts;

import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.media.AudioManager;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.widget.Toast;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.chorem.android.saymytexts.DictateSmsBroadcastReceiver;
import org.chorem.android.saymytexts.SMS;
import org.chorem.android.saymytexts.SayMyTextsUtils;
import org.chorem.android.saymytexts.SayNextActionBroadcastReceiver;

public class SayMyTextService
extends Service
implements TextToSpeech.OnInitListener,
SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String TAG = "SayMyTextService";
    public static final String ACTION_READ_SMS = "org.chorem.android.saymytexts.READ_SMS";
    public static final String ACTION_READ_NEXT_SMS = "org.chorem.android.saymytexts.READ_NEXT_SMS";
    public static final String ACTION_MANAGE_BT_DEVICE = "org.chorem.android.saymytexts.ADD_BT_DEVICE";
    public static final String ACTION_REASK_ACTION = "org.chorem.android.saymytexts.REASK_ACTION";
    public static final String ACTION_DICTATE_SMS = "org.chorem.android.saymytexts.DICTATE_SMS";
    public static final String ACTION_CONFIRM_SMS_SENDING = "org.chorem.android.saymytexts.CONFIRM_SMS_SENDING";
    public static final String INTENT_EXTRA_SMS = "sms";
    public static final String INTENT_EXTRA_BT_DEVICE = "btDevice";
    public static final String INTENT_EXTRA_ADD_BT_DEVICE = "addBtDevice";
    public static final String INTENT_EXTRA_DICTATED_MESSAGE = "dictatedMessage";
    public static final String INTENT_EXTRA_ATTEMPT_NUMBER = "attemptNumber";
    protected static final String BT_ASK_NEXT_ACTION_UTTERANCE_ID = "btAskNextActionUtteranceId";
    protected static final String ASK_NEXT_ACTION_UTTERANCE_ID = "askNextActionUtteranceId";
    protected static final String OTHER_UTTERANCE_ID = "oherUtteranceId";
    protected int maxAttemptNumber;
    protected String readingProfile;
    protected boolean heisendroidModeEnabled;
    protected boolean interactionEnabled;
    protected AudioManager audioManager;
    protected Boolean canSpeak = null;
    protected boolean musicWasActive;
    protected boolean speakerWasOn;
    protected TextToSpeech textToSpeech;
    protected List<SMS> awaitingTexts = new ArrayList<SMS>();
    protected Map<BluetoothDevice, Integer> bluetoothDevices = new HashMap<BluetoothDevice, Integer>();
    protected final PhoneStateListener callStateListener = new PhoneStateListener(){

        public void onCallStateChanged(int state, String incomingNumber) {
            super.onCallStateChanged(state, incomingNumber);
            if (SayMyTextService.this.canSpeak != null) {
                SayMyTextService.this.setCanSpeak(state == 0);
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        this.textToSpeech = new TextToSpeech((Context)this, (TextToSpeech.OnInitListener)this);
        this.audioManager = (AudioManager)this.getSystemService("audio");
        TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
        tm.listen(this.callStateListener, 32);
        IntentFilter intentFilter = new IntentFilter("org.chorem.android.saymytexts.SAY_NEXT_ACTION");
        this.registerReceiver(new SayNextActionBroadcastReceiver(), intentFilter);
        intentFilter = new IntentFilter(ACTION_DICTATE_SMS);
        this.registerReceiver(new DictateSmsBroadcastReceiver(), intentFilter);
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String key = this.getString(2131034115);
        String maxAttemptValue = sharedPref.getString(key, null);
        try {
            this.maxAttemptNumber = Integer.parseInt(maxAttemptValue);
        }
        catch (NumberFormatException e) {
            this.maxAttemptNumber = 3;
        }
        String[] readingProfileValues = this.getResources().getStringArray(2130968576);
        String readingProfileKey = this.getString(2131034112);
        this.readingProfile = sharedPref.getString(readingProfileKey, readingProfileValues[0]);
        String heisendroidModeEnabledKey = this.getString(2131034114);
        this.heisendroidModeEnabled = sharedPref.getBoolean(heisendroidModeEnabledKey, true);
        String interactionPrefKey = this.getString(2131034113);
        this.interactionEnabled = sharedPref.getBoolean(interactionPrefKey, true);
        sharedPref.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void onDestroy() {
        super.onDestroy();
        TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
        tm.listen(this.callStateListener, 0);
        this.textToSpeech.shutdown();
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        sharedPref.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int result = super.onStartCommand(intent, flags, startId);
        if (!SayMyTextsUtils.checkVoiceRecognition((Context)this)) {
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            sharedPref.edit().putBoolean(this.getString(2131034113), false).commit();
        }
        if (intent != null) {
            String action = intent.getAction();
            Log.d((String)TAG, (String)("action " + action));
            SMS sms = (SMS)intent.getSerializableExtra(INTENT_EXTRA_SMS);
            int attemptNumber = intent.getIntExtra(INTENT_EXTRA_ATTEMPT_NUMBER, 0);
            switch (action) {
                case "org.chorem.android.saymytexts.ADD_BT_DEVICE": {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra(INTENT_EXTRA_BT_DEVICE);
                    if (device == null) break;
                    boolean addBtDevice = intent.getBooleanExtra(INTENT_EXTRA_ADD_BT_DEVICE, false);
                    if (addBtDevice) {
                        this.bluetoothDevices.put(device, device.getBluetoothClass().getDeviceClass());
                        break;
                    }
                    this.bluetoothDevices.remove(device);
                    break;
                }
                case "org.chorem.android.saymytexts.REASK_ACTION": {
                    this.askForActionAfterReading(sms, !this.bluetoothDevices.isEmpty(), ++attemptNumber);
                    break;
                }
                case "org.chorem.android.saymytexts.DICTATE_SMS": {
                    this.dictateSMS(sms, attemptNumber + 1);
                    break;
                }
                case "org.chorem.android.saymytexts.CONFIRM_SMS_SENDING": {
                    String dictatedMessage = intent.getStringExtra(INTENT_EXTRA_DICTATED_MESSAGE);
                    this.askSendingConfirmation(dictatedMessage, sms, ++attemptNumber);
                    break;
                }
                case "org.chorem.android.saymytexts.READ_NEXT_SMS": {
                    this.setCanSpeak(true);
                    break;
                }
                default: {
                    String[] readingProfileValues = this.getResources().getStringArray(2130968576);
                    boolean readingEnabled = readingProfileValues[0].equals(this.readingProfile) ? true : (readingProfileValues[1].equals(this.readingProfile) ? this.audioManager.isWiredHeadsetOn() || !this.bluetoothDevices.isEmpty() : (readingProfileValues[2].equals(this.readingProfile) ? this.audioManager.isWiredHeadsetOn() : false));
                    if (!readingEnabled) break;
                    if (!Boolean.FALSE.equals(this.canSpeak)) {
                        this.musicWasActive = this.audioManager.isMusicActive();
                        this.speakerWasOn = this.audioManager.isSpeakerphoneOn();
                        if (this.musicWasActive) {
                            this.audioManager.setStreamMute(3, this.musicWasActive);
                        }
                        if (readingProfileValues[0].equals(this.readingProfile) && !this.audioManager.isWiredHeadsetOn() && this.bluetoothDevices.isEmpty()) {
                            this.audioManager.setMode(2);
                            this.audioManager.setSpeakerphoneOn(true);
                        }
                    }
                    if (Boolean.TRUE.equals(this.canSpeak)) {
                        this.requestReading(sms);
                        break;
                    }
                    this.awaitingTexts.add(sms);
                }
            }
            result = 1;
        }
        return result;
    }

    public void onInit(int status) {
        if (status == 0) {
            TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
            this.setCanSpeak(tm.getCallState() == 0);
        } else {
            this.setCanSpeak(null);
            Toast.makeText((Context)this, (int)2131034138, (int)1).show();
            this.stopSelf();
        }
    }

    protected void setCanSpeak(Boolean canSpeak) {
        this.canSpeak = canSpeak;
        if (Boolean.TRUE.equals(canSpeak)) {
            if (!this.awaitingTexts.isEmpty()) {
                SMS sms = this.awaitingTexts.remove(0);
                this.requestReading(sms);
            } else {
                if (!this.bluetoothDevices.isEmpty()) {
                    this.audioManager.stopBluetoothSco();
                }
                if (this.musicWasActive) {
                    this.audioManager.setStreamMute(3, false);
                }
                this.audioManager.setSpeakerphoneOn(this.speakerWasOn);
                this.audioManager.setMode(0);
            }
        }
    }

    protected void requestReading(final SMS sms) {
        if (this.bluetoothDevices.isEmpty()) {
            this.readText(sms, false);
        } else {
            this.requestBluetoothSpeakingActivation(new Function<Void, Void>(){

                public Void apply(Void input) {
                    SayMyTextService.this.readText(sms, true);
                    return null;
                }
            });
        }
    }

    protected void requestBluetoothSpeakingActivation(final Function<Void, Void> callback) {
        this.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int state = intent.getExtras().getInt("android.media.extra.SCO_AUDIO_STATE");
                if (state == 1) {
                    context.unregisterReceiver((BroadcastReceiver)this);
                    callback.apply(null);
                }
            }
        }, new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED"));
        this.audioManager.setMode(2);
        this.audioManager.startBluetoothSco();
    }

    protected void readText(SMS sms, boolean btConnected) {
        this.setCanSpeak(false);
        this.textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

            public void onStart(String utteranceId) {
            }

            public void onError(String utteranceId) {
                Log.e((String)SayMyTextService.TAG, (String)("Error speaking: " + utteranceId));
            }

            public void onDone(String utteranceId) {
                Log.d((String)SayMyTextService.TAG, (String)"done");
                SayMyTextService.this.setCanSpeak(true);
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("streamType", String.valueOf(0));
        if (this.heisendroidModeEnabled) {
            this.textToSpeech.setLanguage(Locale.US);
            this.textToSpeech.setSpeechRate(0.3f);
            this.textToSpeech.setPitch(0.1f);
            this.textToSpeech.speak("Say my text.", 1, params);
        }
        if (!this.interactionEnabled && !this.heisendroidModeEnabled) {
            params.put("utteranceId", OTHER_UTTERANCE_ID);
        }
        this.textToSpeech.setLanguage(Locale.getDefault());
        this.textToSpeech.setSpeechRate(1.0f);
        this.textToSpeech.setPitch(1.0f);
        String text = this.getString(2131034122, new Object[]{sms.getSenderName(), sms.getMessage()});
        this.textToSpeech.speak(text, 1, params);
        if (this.heisendroidModeEnabled) {
            if (this.interactionEnabled) {
                params.put("utteranceId", OTHER_UTTERANCE_ID);
            }
            this.textToSpeech.setLanguage(Locale.US);
            this.textToSpeech.setSpeechRate(0.3f);
            this.textToSpeech.setPitch(0.1f);
            this.textToSpeech.speak("You're goddamn right.", 1, params);
        }
        if (this.interactionEnabled) {
            this.askForActionAfterReading(sms, btConnected, 1);
        }
    }

    protected void askForActionAfterReading(final SMS sms, boolean btConnected, final int attemptNumber) {
        this.textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

            public void onStart(String utteranceId) {
            }

            public void onError(String utteranceId) {
                Log.e((String)SayMyTextService.TAG, (String)("Error speaking: " + utteranceId));
            }

            public void onDone(String utteranceId) {
                if (SayMyTextService.ASK_NEXT_ACTION_UTTERANCE_ID.equals(utteranceId) || SayMyTextService.BT_ASK_NEXT_ACTION_UTTERANCE_ID.equals(utteranceId)) {
                    Intent sayaction = new Intent("org.chorem.android.saymytexts.SAY_NEXT_ACTION");
                    sayaction.putExtra(SayMyTextService.INTENT_EXTRA_SMS, (Serializable)sms);
                    sayaction.putExtra(SayMyTextService.INTENT_EXTRA_ATTEMPT_NUMBER, attemptNumber);
                    sayaction.putExtra("fallbackAction", SayMyTextService.ACTION_REASK_ACTION);
                    SayMyTextService.this.sendBroadcast(sayaction);
                }
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("streamType", String.valueOf(0));
        this.textToSpeech.setLanguage(Locale.getDefault());
        this.textToSpeech.setSpeechRate(1.0f);
        this.textToSpeech.setPitch(1.0f);
        if (attemptNumber > 1) {
            this.textToSpeech.speak(this.getString(2131034154), 1, params);
        }
        if (attemptNumber <= this.maxAttemptNumber) {
            params.put("utteranceId", btConnected ? BT_ASK_NEXT_ACTION_UTTERANCE_ID : ASK_NEXT_ACTION_UTTERANCE_ID);
            this.textToSpeech.speak(this.getString(2131034145), 1, params);
        } else {
            this.setCanSpeak(true);
        }
    }

    protected void dictateSMS(final SMS sms, final int attemptNumber) {
        Log.d((String)TAG, (String)"dictateSMS ");
        this.textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

            public void onStart(String utteranceId) {
            }

            public void onError(String utteranceId) {
                Log.e((String)SayMyTextService.TAG, (String)("Error speaking: " + utteranceId));
            }

            public void onDone(String utteranceId) {
                Intent dictateAction = new Intent(SayMyTextService.ACTION_DICTATE_SMS);
                dictateAction.putExtra(SayMyTextService.INTENT_EXTRA_SMS, (Serializable)sms);
                dictateAction.putExtra(SayMyTextService.INTENT_EXTRA_ATTEMPT_NUMBER, attemptNumber);
                SayMyTextService.this.sendBroadcast(dictateAction);
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("streamType", String.valueOf(0));
        if (attemptNumber > 1) {
            this.textToSpeech.speak(this.getString(2131034154), 1, params);
        }
        if (attemptNumber <= this.maxAttemptNumber) {
            params.put("utteranceId", OTHER_UTTERANCE_ID);
            this.textToSpeech.setLanguage(Locale.getDefault());
            this.textToSpeech.setSpeechRate(1.0f);
            this.textToSpeech.setPitch(1.0f);
            this.textToSpeech.speak(this.getString(2131034146), 1, params);
        } else {
            this.setCanSpeak(true);
        }
    }

    protected void askSendingConfirmation(final String message, final SMS originSms, final int attemptNumber) {
        Log.d((String)TAG, (String)("askSendingConfirmation " + message));
        this.textToSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

            public void onStart(String utteranceId) {
            }

            public void onError(String utteranceId) {
                Log.e((String)SayMyTextService.TAG, (String)("Error speaking: " + utteranceId));
            }

            public void onDone(String utteranceId) {
                Intent sayaction = new Intent("org.chorem.android.saymytexts.SAY_NEXT_ACTION");
                sayaction.putExtra(SayMyTextService.INTENT_EXTRA_SMS, (Serializable)originSms);
                sayaction.putExtra("message", message);
                sayaction.putExtra(SayMyTextService.INTENT_EXTRA_ATTEMPT_NUMBER, attemptNumber);
                sayaction.putExtra("fallbackAction", SayMyTextService.ACTION_CONFIRM_SMS_SENDING);
                SayMyTextService.this.sendBroadcast(sayaction);
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("streamType", String.valueOf(0));
        this.textToSpeech.setLanguage(Locale.getDefault());
        this.textToSpeech.setSpeechRate(1.0f);
        this.textToSpeech.setPitch(1.0f);
        if (attemptNumber > 1) {
            this.textToSpeech.speak(this.getString(2131034154), 1, params);
        }
        if (attemptNumber <= this.maxAttemptNumber) {
            params.put("utteranceId", OTHER_UTTERANCE_ID);
            String text = this.getString(2131034147, new Object[]{message});
            this.textToSpeech.speak(text, 1, params);
        } else {
            this.setCanSpeak(true);
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (key.equals(this.getString(2131034115))) {
            String maxAttemptValue = sharedPreferences.getString(key, null);
            try {
                this.maxAttemptNumber = Integer.parseInt(maxAttemptValue);
            }
            catch (NumberFormatException e) {
                this.maxAttemptNumber = 3;
            }
        } else if (key.equals(this.getString(2131034112))) {
            String[] readingProfileValues = this.getResources().getStringArray(2130968576);
            this.readingProfile = sharedPreferences.getString(key, readingProfileValues[0]);
        } else if (key.equals(this.getString(2131034114))) {
            this.heisendroidModeEnabled = sharedPreferences.getBoolean(key, true);
        } else if (key.equals(this.getString(2131034113))) {
            this.interactionEnabled = sharedPreferences.getBoolean(key, true);
        }
    }
}

