/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.google.utils.geocode;

import org.chenillekit.google.utils.JSONException;
import org.chenillekit.google.utils.JSONObject;
import org.chenillekit.google.utils.geocode.AddressDetails;
import org.chenillekit.google.utils.geocode.LatLng;

public class Placemark {
    private AddressDetails addressDetails;
    private LatLng latLng;
    private String address;
    private String id;

    public Placemark(JSONObject json) {
        this.buildFromJSON(json);
    }

    private void buildFromJSON(JSONObject json) {
        try {
            this.address = json.getString("address");
            this.id = json.getString("id");
            this.addressDetails = new AddressDetails(json.getJSONObject("AddressDetails"));
            this.latLng = new LatLng(json.getJSONObject("Point"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public AddressDetails getAddressDetails() {
        return this.addressDetails;
    }

    public String getAddress() {
        return this.address;
    }

    public String getId() {
        return this.id;
    }

    public LatLng getLatLng() {
        return this.latLng;
    }
}

