/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class MethodAccessNode
extends Node {
    protected ExpressionTree tree;
    protected ExecutableElement method;
    protected Node receiver;

    public MethodAccessNode(ExpressionTree tree, Node receiver) {
        super(InternalUtils.typeOf((Tree)tree));
        assert (TreeUtils.isMethodAccess((Tree)tree));
        this.tree = tree;
        this.method = (ExecutableElement)TreeUtils.elementFromUse((ExpressionTree)tree);
        this.receiver = receiver;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitMethodAccess(this, p);
    }

    public String toString() {
        return this.getReceiver() + "." + this.method.getSimpleName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MethodAccessNode)) {
            return false;
        }
        MethodAccessNode other = (MethodAccessNode)obj;
        return this.getReceiver().equals(other.getReceiver()) && this.getMethod().equals(other.getMethod());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getReceiver(), this.getMethod());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.receiver);
    }
}

