/**
 * SyntaxHighlighter
 * http://alexgorbatchev.com/
 *
 * SyntaxHighlighter is donationware. If you are using it, please donate.
 * http://alexgorbatchev.com/wiki/SyntaxHighlighter:Donate
 *
 * @version
 * 2.0.320 (May 03 2009)
 * 
 * @copyright
 * Copyright (C) 2004-2009 Alex Gorbatchev.
 *
 * @license
 * This file is part of SyntaxHighlighter.
 * 
 * SyntaxHighlighter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SyntaxHighlighter is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with SyntaxHighlighter.  If not, see <http://www.gnu.org/copyleft/lesser.html>.
 */
if(!window.SyntaxHighlighter){var SyntaxHighlighter=function(){var a={defaults:{"class-name":"","first-line":1,highlight:null,"smart-tabs":true,"tab-size":4,ruler:false,gutter:true,toolbar:true,collapse:false,"auto-links":true,light:false,"wrap-lines":true},config:{clipboardSwf:null,toolbarItemWidth:16,toolbarItemHeight:16,bloggerMode:false,stripBrs:false,tagName:"pre",strings:{expandSource:"expand source",viewSource:"view source",copyToClipboard:"copy to clipboard",copyToClipboardConfirmation:"The code is in your clipboard now",print:"print",help:"?",alert:"SyntaxHighlighter\n\n",noBrush:"Can't find brush for: ",brushNotHtmlScript:"Brush wasn't configured for html-script option: ",aboutDialog:'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><title>About SyntaxHighlighter</title></head><body style="font-family:Geneva,Arial,Helvetica,sans-serif;background-color:#fff;color:#000;font-size:1em;text-align:center;"><div style="text-align:center;margin-top:3em;"><div style="font-size:xx-large;">SyntaxHighlighter</div><div style="font-size:.75em;margin-bottom:4em;"><div>version 2.0.320 (May 03 2009)</div><div><a href="http://alexgorbatchev.com" target="_blank" style="color:#0099FF;text-decoration:none;">http://alexgorbatchev.com</a></div></div><div>JavaScript code syntax highlighter.</div><div>Copyright 2004-2009 Alex Gorbatchev.</div></div></body></html>'},debug:false},vars:{discoveredBrushes:null,spaceWidth:null,printFrame:null,highlighters:{}},brushes:{},regexLib:{multiLineCComments:/\/\*[\s\S]*?\*\//gm,singleLineCComments:/\/\/.*$/gm,singleLinePerlComments:/#.*$/gm,doubleQuotedString:/"(?:\.|(\\\")|[^\""\n])*"/g,singleQuotedString:/'(?:\.|(\\\')|[^\''\n])*'/g,multiLineDoubleQuotedString:/"(?:\.|(\\\")|[^\""])*"/g,multiLineSingleQuotedString:/'(?:\.|(\\\')|[^\''])*'/g,url:/\w+:\/\/[\w-.\/?%&=]*/g,phpScriptTags:{left:/(&lt;|<)\?=?/g,right:/\?(&gt;|>)/g},aspScriptTags:{left:/(&lt;|<)%=?/g,right:/%(&gt;|>)/g},scriptScriptTags:{left:/(&lt;|<)\s*script.*?(&gt;|>)/gi,right:/(&lt;|<)\/\s*script\s*(&gt;|>)/gi}},toolbar:{create:function(d){var h=document.createElement("DIV"),b=a.toolbar.items;h.className="toolbar";for(var c in b){var f=b[c],g=new f(d),e=g.create();d.toolbarCommands[c]=g;if(e==null){continue}if(typeof(e)=="string"){e=a.toolbar.createButton(e,d.id,c)}e.className+="item "+c;h.appendChild(e)}return h},createButton:function(f,c,g){var d=document.createElement("a"),i=d.style,e=a.config,h=e.toolbarItemWidth,b=e.toolbarItemHeight;d.href="#"+g;d.title=f;d.highlighterId=c;d.commandName=g;d.innerHTML=f;if(isNaN(h)==false){i.width=h+"px"}if(isNaN(b)==false){i.height=b+"px"}d.onclick=function(j){try{a.toolbar.executeCommand(this,j||window.event,this.highlighterId,this.commandName)}catch(j){a.utils.alert(j.message)}return false};return d},executeCommand:function(f,g,b,e,d){var c=a.vars.highlighters[b],h;if(c==null||(h=c.toolbarCommands[e])==null){return null}return h.execute(f,g,d)},items:{expandSource:function(b){this.create=function(){if(b.getParam("collapse")!=true){return}return a.config.strings.expandSource};this.execute=function(d,e,c){var f=b.div;d.parentNode.removeChild(d);f.className=f.className.replace("collapsed","")}},viewSource:function(b){this.create=function(){return a.config.strings.viewSource};this.execute=function(d,g,c){var f=a.utils.fixInputString(b.originalCode).replace(/</g,"&lt;"),e=a.utils.popup("","_blank",750,400,"location=0, resizable=1, menubar=0, scrollbars=1");f=a.utils.unindent(f);e.document.write("<pre>"+f+"</pre>");e.document.close()}},copyToClipboard:function(d){var e,c,b=d.id;this.create=function(){var g=a.config;if(g.clipboardSwf==null){return null}function l(o){var m="";for(var n in o){m+="<param name='"+n+"' value='"+o[n]+"'/>"}return m}function f(o){var m="";for(var n in o){m+=" "+n+"='"+o[n]+"'"}return m}var k={width:g.toolbarItemWidth,height:g.toolbarItemHeight,id:b+"_clipboard",type:"application/x-shockwave-flash",title:a.config.strings.copyToClipboard},j={allowScriptAccess:"always",wmode:"transparent",flashVars:"highlighterId="+b,menu:"false"},i=g.clipboardSwf,h;if(/msie/i.test(navigator.userAgent)){h="<object"+f({classid:"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000",codebase:"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0"})+f(k)+">"+l(j)+l({movie:i})+"</object>"}else{h="<embed"+f(k)+f(j)+f({src:i})+"/>"}e=document.createElement("div");e.innerHTML=h;return e};this.execute=function(g,i,f){var j=f.command;switch(j){case"get":var h=a.utils.unindent(a.utils.fixInputString(d.originalCode).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&amp;/g,"&"));if(window.clipboardData){window.clipboardData.setData("text",h)}else{return a.utils.unindent(h)}case"ok":a.utils.alert(a.config.strings.copyToClipboardConfirmation);break;case"error":a.utils.alert(f.message);break}}},printSource:function(b){this.create=function(){return a.config.strings.print};this.execute=function(e,g,d){var f=document.createElement("IFRAME"),h=null;if(a.vars.printFrame!=null){document.body.removeChild(a.vars.printFrame)}a.vars.printFrame=f;f.style.cssText="position:absolute;width:0px;height:0px;left:-500px;top:-500px;";document.body.appendChild(f);h=f.contentWindow.document;c(h,window.document);h.write('<div class="'+b.div.className.replace("collapsed","")+' printing">'+b.div.innerHTML+"</div>");h.close();f.contentWindow.focus();f.contentWindow.print();function c(j,m){var k=m.getElementsByTagName("link");for(var l=0;l<k.length;l++){if(k[l].rel.toLowerCase()=="stylesheet"&&/shCore\.css$/.test(k[l].href)){j.write('<link type="text/css" rel="stylesheet" href="'+k[l].href+'"></link>')}}}}},about:function(b){this.create=function(){return a.config.strings.help};this.execute=function(c,e){var d=a.utils.popup("","_blank",500,250,"scrollbars=0"),f=d.document;f.write(a.config.strings.aboutDialog);f.close();d.focus()}}}},utils:{guid:function(b){return b+Math.round(Math.random()*1000000).toString()},merge:function(e,d){var b={},c;for(c in e){b[c]=e[c]}for(c in d){b[c]=d[c]}return b},toBoolean:function(b){switch(b){case"true":return true;case"false":return false}return b},popup:function(f,e,g,c,d){var b=(screen.width-g)/2,i=(screen.height-c)/2;d+=", left="+b+", top="+i+", width="+g+", height="+c;d=d.replace(/^,/,"");var h=window.open(f,e,d);h.focus();return h},addEvent:function(d,b,c){if(d.attachEvent){d["e"+b+c]=c;d[b+c]=function(){d["e"+b+c](window.event)};d.attachEvent("on"+b,d[b+c])}else{d.addEventListener(b,c,false)}},alert:function(b){alert(a.config.strings.alert+b)},findBrush:function(f,h){var g=a.vars.discoveredBrushes,b=null;if(g==null){g={};for(var d in a.brushes){var c=a.brushes[d].aliases;if(c==null){continue}for(var e=0;e<c.length;e++){g[c[e]]=d}}a.vars.discoveredBrushes=g}b=a.brushes[g[f]];if(b==null&&h!=false){a.utils.alert(a.config.strings.noBrush+f)}return b},eachLine:function(d,e){var b=d.split("\n");for(var c=0;c<b.length;c++){b[c]=e(b[c])}return b.join("\n")},createRuler:function(){var e=document.createElement("div"),d=document.createElement("div"),c=10,b=1;while(b<=150){if(b%c===0){e.innerHTML+=b;b+=(b+"").length}else{e.innerHTML+="&middot;";b++}}d.className="ruler line";d.appendChild(e);return d},trimFirstAndLastLines:function(b){return b.replace(/^[ ]*[\n]+|[\n]*[ ]*$/g,"")},parseParams:function(h){var d,c={},e=new XRegExp("^\\[(?<values>(.*?))\\]$"),f=new XRegExp("(?<name>[\\w-]+)\\s*:\\s*(?<value>[\\w-%#]+|\\[.*?\\]|\".*?\"|'.*?')\\s*;?","g");while((d=f.exec(h))!=null){var g=d.value.replace(/^['"]|['"]$/g,"");if(g!=null&&e.test(g)){var b=e.exec(g);g=b.values.length>0?b.values.split(/\s*,\s*/):[]}c[d.name]=g}return c},decorate:function(c,b){if(c==null||c.length==0||c=="\n"){return c}c=c.replace(/</g,"&lt;");c=c.replace(/ {2,}/g,function(d){var e="";for(var f=0;f<d.length-1;f++){e+="&nbsp;"}return e+" "});if(b!=null){c=a.utils.eachLine(c,function(d){if(d.length==0){return""}var e="";d=d.replace(/^(&nbsp;| )+/,function(f){e=f;return""});if(d.length==0){return e}return e+'<code class="'+b+'">'+d+"</code>"})}return c},padNumber:function(d,c){var b=d.toString();while(b.length<c){b="0"+b}return b},measureSpace:function(){var c=document.createElement("div"),h,j=0,f=document.body,d=a.utils.guid("measureSpace"),i='<div class="',g="</div>",e="</span>";c.innerHTML=i+'syntaxhighlighter">'+i+'lines">'+i+'line">'+i+'content"><span class="block"><span id="'+d+'">&nbsp;'+e+e+g+g+g+g;f.appendChild(c);h=document.getElementById(d);if(/opera/i.test(navigator.userAgent)){var b=window.getComputedStyle(h,null);j=parseInt(b.getPropertyValue("width"))}else{j=h.offsetWidth}f.removeChild(c);return j},processTabs:function(d,e){var c="";for(var b=0;b<e;b++){c+=" "}return d.replace(/\t/g,c)},processSmartTabs:function(f,g){var b=f.split("\n"),e="\t",c="";for(var d=0;d<50;d++){c+="                    "}function h(i,k,j){return i.substr(0,k)+c.substr(0,j)+i.substr(k+1,i.length)}f=a.utils.eachLine(f,function(i){if(i.indexOf(e)==-1){return i}var k=0;while((k=i.indexOf(e))!=-1){var j=g-k%g;i=h(i,k,j)}return i});return f},fixInputString:function(c){var b=/<br\s*\/?>|&lt;br\s*\/?&gt;/gi;if(a.config.bloggerMode==true){c=c.replace(b,"\n")}if(a.config.stripBrs==true){c=c.replace(b,"")}return c},trim:function(b){return b.replace(/\s*$/g,"").replace(/^\s*/,"")},unindent:function(j){var c=a.utils.fixInputString(j).split("\n"),h=new Array(),f=/^\s*/,e=1000;for(var d=0;d<c.length&&e>0;d++){var b=c[d];if(a.utils.trim(b).length==0){continue}var g=f.exec(b);if(g==null){return j}e=Math.min(g[0].length,e)}if(e>0){for(var d=0;d<c.length;d++){c[d]=c[d].substr(e)}}return c.join("\n")},matchesSortCallback:function(c,b){if(c.index<b.index){return -1}else{if(c.index>b.index){return 1}else{if(c.length<b.length){return -1}else{if(c.length>b.length){return 1}}}}return 0},getMatches:function(f,g){function h(i,j){return[new a.Match(i[0],i.index,j.css)]}var d=0,c=null,b=[],e=g.func?g.func:h;while((c=g.regex.exec(f))!=null){b=b.concat(e(c,g))}return b},processUrls:function(b){return b.replace(a.regexLib.url,function(c){return'<a href="'+c+'">'+c+"</a>"})}},highlight:function(g,e){function d(q){var o=[];for(var p=0;p<q.length;p++){o.push(q[p])}return o}var b=e?[e]:d(document.getElementsByTagName(a.config.tagName)),h="innerHTML",l=null;if(b.length===0){return}for(var f=0;f<b.length;f++){var j=b[f],c=a.utils.parseParams(j.className),m;c=a.utils.merge(g,c);m=c.brush;if(m==null){continue}if(c["html-script"]=="true"){l=new a.HtmlScript(m)}else{var k=a.utils.findBrush(m);if(k){l=new k()}else{continue}}l.highlight(j[h],c);var n=l.div;if(a.config.debug){n=document.createElement("textarea");n.value=l.div.innerHTML;n.style.width="70em";n.style.height="30em"}j.parentNode.replaceChild(n,j)}},all:function(b){a.utils.addEvent(window,"load",function(){a.highlight(b)})}};a.Match=function(d,b,c){this.value=d;this.index=b;this.length=d.length;this.css=c};a.Match.prototype.toString=function(){return this.value};a.HtmlScript=function(b){var c=a.utils.findBrush(b),g=new a.brushes.Xml(),f=null;if(c==null){return}c=new c();this.xmlBrush=g;if(c.htmlScript==null){a.utils.alert(a.config.strings.brushNotHtmlScript+b);return}g.regexList.push({regex:c.htmlScript.code,func:e});function d(i,k){for(var h=0;h<i.length;h++){i[h].index+=k}}function e(o,j){var h=o.code,n=[],m=c.regexList,k=o.index+o.left.length,p=c.htmlScript,q;for(var l=0;l<m.length;l++){q=a.utils.getMatches(h,m[l]);d(q,k);n=n.concat(q)}if(p.left!=null&&o.left!=null){q=a.utils.getMatches(o.left,p.left);d(q,o.index);n=n.concat(q)}if(p.right!=null&&o.right!=null){q=a.utils.getMatches(o.right,p.right);d(q,o.index+o[0].lastIndexOf(o.right));n=n.concat(q)}return n}};a.HtmlScript.prototype.highlight=function(b,c){this.xmlBrush.highlight(b,c);this.div=this.xmlBrush.div};a.Highlighter=function(){};a.Highlighter.prototype={getParam:function(d,c){var b=this.params[d];return a.utils.toBoolean(b==null?c:b)},create:function(b){return document.createElement(b)},findMatches:function(e,d){var b=[];if(e!=null){for(var c=0;c<e.length;c++){b=b.concat(a.utils.getMatches(d,e[c]))}}b=b.sort(a.utils.matchesSortCallback);return b},removeNestedMatches:function(){var f=this.matches;for(var e=0;e<f.length;e++){if(f[e]===null){continue}var b=f[e],d=b.index+b.length;for(var c=e+1;c<f.length&&f[e]!==null;c++){var g=f[c];if(g===null){continue}else{if(g.index>d){break}else{if(g.index==b.index&&g.length>b.length){this.matches[e]=null}else{if(g.index>=b.index&&g.index<d){this.matches[c]=null}}}}}}},createDisplayLines:function(b){var n=b.split(/\n/g),l=parseInt(this.getParam("first-line")),h=(l+n.length).toString().length,m=this.getParam("highlight",[]);var e=this.getParam("gutter");b="";for(var g=0;g<n.length;g++){var o=n[g],c=/^(&nbsp;|\s)+/.exec(o),k="line alt"+(g%2==0?1:2),d=a.utils.padNumber(l+g,h),f=m.indexOf((l+g).toString())!=-1,j=null;if(c!=null){j=c[0].toString();o=o.substr(j.length);j=j.replace(/&nbsp;/g," ");c=a.vars.spaceWidth*j.length}else{c=0}o=a.utils.trim(o);if(o.length==0){o="&nbsp;"}if(f){k+=" highlighted"}b+='<div class="'+k+'">'+(e?'<code class="number">'+d+".</code>":"")+'<span class="content">'+(j!=null?'<code class="spaces">'+j.replace(/\s/g,"&nbsp;")+"</code>":"")+'<span class="block" style="margin-left: '+c+'px !important;">'+o+"</span></span></div>"}return b},processMatches:function(e,f){var h=0,b="",g=a.utils.decorate;for(var d=0;d<f.length;d++){var c=f[d];if(c===null||c.length===0){continue}b+=g(e.substr(h,c.index-h),"plain")+g(c.value,c.css);h=c.index+c.length}b+=g(e.substr(h),"plain");return b},highlight:function(c,e){var j=a.config,k=a.vars,b,g,h,d="important";this.params={};this.div=null;this.lines=null;this.code=null;this.bar=null;this.toolbarCommands={};this.id=a.utils.guid("highlighter_");k.highlighters[this.id]=this;if(c===null){c=""}if(k.spaceWidth===null){k.spaceWidth=a.utils.measureSpace()}this.params=a.utils.merge(a.defaults,e||{});if(this.getParam("light")==true){this.params.toolbar=this.params.gutter=false}this.div=b=this.create("DIV");this.lines=this.create("DIV");this.lines.className="lines";className="syntaxhighlighter";b.id=this.id;if(this.getParam("collapse")){className+=" collapsed"}if(this.getParam("gutter")==false){className+=" nogutter"}if(this.getParam("wrap-lines")==false){this.lines.className+=" no-wrap"}className+=" "+this.getParam("class-name");b.className=className;this.originalCode=c;this.code=a.utils.trimFirstAndLastLines(c).replace(/\r/g," ");h=this.getParam("tab-size");this.code=this.getParam("smart-tabs")==true?a.utils.processSmartTabs(this.code,h):a.utils.processTabs(this.code,h);this.code=a.utils.unindent(this.code);if(this.getParam("toolbar")){this.bar=this.create("DIV");this.bar.className="bar";this.bar.appendChild(a.toolbar.create(this));b.appendChild(this.bar);var i=this.bar;function f(){i.className=i.className.replace("show","")}b.onmouseover=function(){f();i.className+=" show"};b.onmouseout=function(){f()}}if(this.getParam("ruler")){b.appendChild(a.utils.createRuler())}b.appendChild(this.lines);this.matches=this.findMatches(this.regexList,this.code);this.removeNestedMatches();c=this.processMatches(this.code,this.matches);c=this.createDisplayLines(a.utils.trim(c));if(this.getParam("auto-links")){c=a.utils.processUrls(c)}this.lines.innerHTML=c},getKeywords:function(b){b=b.replace(/^\s+|\s+$/g,"").replace(/\s+/g,"\\b|\\b");return"\\b"+b+"\\b"},forHtmlScript:function(b){this.htmlScript={left:{regex:b.left,css:"script"},right:{regex:b.right,css:"script"},code:new XRegExp("(?<left>"+b.left.source+")(?<code>.*?)(?<right>"+b.right.source+")","sgi")}}};return a}()}if(!Array.indexOf){Array.prototype.indexOf=function(a,c){c=Math.max(c||0,0);for(var b=c;b<this.length;b++){if(this[b]==a){return b}}return -1}}if(!window.XRegExp){(function(){var e={exec:RegExp.prototype.exec,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},d={part:/(?:[^\\([#\s.]+|\\(?!k<[\w$]+>|[pP]{[^}]+})[\S\s]?|\((?=\?(?!#|<[\w$]+>)))+|(\()(?:\?(?:(#)[^)]*\)|<([$\w]+)>))?|\\(?:k<([\w$]+)>|[pP]{([^}]+)})|(\[\^?)|([\S\s])/g,replaceVar:/(?:[^$]+|\$(?![1-9$&`']|{[$\w]+}))+|\$(?:([1-9]\d*|[$&`'])|{([$\w]+)})/g,extended:/^(?:\s+|#.*)+/,quantifier:/^(?:[?*+]|{\d+(?:,\d*)?})/,classLeft:/&&\[\^?/g,classRight:/]/g},b=function(j,g,h){for(var f=h||0;f<j.length;f++){if(j[f]===g){return f}}return -1},c=/()??/.exec("")[1]!==undefined,a={};XRegExp=function(o,i){if(o instanceof RegExp){if(i!==undefined){throw TypeError("can't supply flags when constructing one RegExp from another")}return o.addFlags()}var i=i||"",f=i.indexOf("s")>-1,k=i.indexOf("x")>-1,p=false,r=[],h=[],g=d.part,l,j,n,m,q;g.lastIndex=0;while(l=e.exec.call(g,o)){if(l[2]){if(!d.quantifier.test(o.slice(g.lastIndex))){h.push("(?:)")}}else{if(l[1]){r.push(l[3]||null);if(l[3]){p=true}h.push("(")}else{if(l[4]){m=b(r,l[4]);h.push(m>-1?"\\"+(m+1)+(isNaN(o.charAt(g.lastIndex))?"":"(?:)"):l[0])}else{if(l[5]){h.push(a.unicode?a.unicode.get(l[5],l[0].charAt(1)==="P"):l[0])}else{if(l[6]){if(o.charAt(g.lastIndex)==="]"){h.push(l[6]==="["?"(?!)":"[\\S\\s]");g.lastIndex++}else{j=XRegExp.matchRecursive("&&"+o.slice(l.index),d.classLeft,d.classRight,"",{escapeChar:"\\"})[0];h.push(l[6]+j+"]");g.lastIndex+=j.length+1}}else{if(l[7]){if(f&&l[7]==="."){h.push("[\\S\\s]")}else{if(k&&d.extended.test(l[7])){n=e.exec.call(d.extended,o.slice(g.lastIndex-1))[0].length;if(!d.quantifier.test(o.slice(g.lastIndex-1+n))){h.push("(?:)")}g.lastIndex+=n-1}else{h.push(l[7])}}}else{h.push(l[0])}}}}}}}q=RegExp(h.join(""),e.replace.call(i,/[sx]+/g,""));q._x={source:o,captureNames:p?r:null};return q};XRegExp.addPlugin=function(f,g){a[f]=g};RegExp.prototype.exec=function(k){var h=e.exec.call(this,k),g,j,f;if(h){if(c&&h.length>1){f=new RegExp("^"+this.source+"$(?!\\s)",this.getNativeFlags());e.replace.call(h[0],f,function(){for(j=1;j<arguments.length-2;j++){if(arguments[j]===undefined){h[j]=undefined}}})}if(this._x&&this._x.captureNames){for(j=1;j<h.length;j++){g=this._x.captureNames[j-1];if(g){h[g]=h[j]}}}if(this.global&&this.lastIndex>(h.index+h[0].length)){this.lastIndex--}}return h}})()}RegExp.prototype.getNativeFlags=function(){return(this.global?"g":"")+(this.ignoreCase?"i":"")+(this.multiline?"m":"")+(this.extended?"x":"")+(this.sticky?"y":"")};RegExp.prototype.addFlags=function(a){var b=new XRegExp(this.source,(a||"")+this.getNativeFlags());if(this._x){b._x={source:this._x.source,captureNames:this._x.captureNames?this._x.captureNames.slice(0):null}}return b};RegExp.prototype.call=function(a,b){return this.exec(b)};RegExp.prototype.apply=function(b,a){return this.exec(a[0])};XRegExp.cache=function(c,a){var b="/"+c+"/"+(a||"");return XRegExp.cache[b]||(XRegExp.cache[b]=new XRegExp(c,a))};XRegExp.escape=function(a){return a.replace(/[-[\]{}()*+?.\\^$|,#\s]/g,"\\$&")};XRegExp.matchRecursive=function(p,d,s,f,b){var b=b||{},v=b.escapeChar,k=b.valueNames,f=f||"",q=f.indexOf("g")>-1,c=f.indexOf("i")>-1,h=f.indexOf("m")>-1,u=f.indexOf("y")>-1,f=f.replace(/y/g,""),d=d instanceof RegExp?(d.global?d:d.addFlags("g")):new XRegExp(d,"g"+f),s=s instanceof RegExp?(s.global?s:s.addFlags("g")):new XRegExp(s,"g"+f),i=[],a=0,j=0,n=0,l=0,m,e,o,r,g,t;if(v){if(v.length>1){throw SyntaxError("can't supply more than one escape character")}if(h){throw TypeError("can't supply escape character when using the multiline flag")}g=XRegExp.escape(v);t=new RegExp("^(?:"+g+"[\\S\\s]|(?:(?!"+d.source+"|"+s.source+")[^"+g+"])+)+",c?"i":"")}while(true){d.lastIndex=s.lastIndex=n+(v?(t.exec(p.slice(n))||[""])[0].length:0);o=d.exec(p);r=s.exec(p);if(o&&r){if(o.index<=r.index){r=null}else{o=null}}if(o||r){j=(o||r).index;n=(o?d:s).lastIndex}else{if(!a){break}}if(u&&!a&&j>l){break}if(o){if(!a++){m=j;e=n}}else{if(r&&a){if(!--a){if(k){if(k[0]&&m>l){i.push([k[0],p.slice(l,m),l,m])}if(k[1]){i.push([k[1],p.slice(m,e),m,e])}if(k[2]){i.push([k[2],p.slice(e,j),e,j])}if(k[3]){i.push([k[3],p.slice(j,n),j,n])}}else{i.push(p.slice(e,j))}l=n;if(!q){break}}}else{d.lastIndex=s.lastIndex=0;throw Error("subject data contains unbalanced delimiters")}}if(j===n){n++}}if(q&&!u&&k&&k[0]&&p.length>l){i.push([k[0],p.slice(l),l,p.length])}d.lastIndex=s.lastIndex=0;return i};
