/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.core.timing.TimerStructure;
import org.cache2k.core.timing.TimerTask;

public class TimerWheels
implements TimerStructure {
    private final Wheel wheel;
    private final long delta;

    public TimerWheels(long startTime, long delta, int slots) {
        this.delta = delta;
        this.wheel = new Wheel(startTime, delta, slots);
    }

    @Override
    public long schedule(TimerTask task, long time) {
        task.time = time;
        if (this.wheel.schedule(task)) {
            long slotTime = time + (this.delta - (time - this.wheel.noon) % this.delta) - 1L;
            if (slotTime < 0L) {
                return 0x7FFFFFFFFFFFFFFEL;
            }
            return slotTime;
        }
        return 0L;
    }

    @Override
    public void cancelAll() {
        this.wheel.cancel();
    }

    @Override
    public TimerTask removeNextToRun(long time) {
        TimerTask t = this.wheel.removeNextToRun(time);
        return t;
    }

    @Override
    public long nextRun() {
        return this.wheel.nextToRun();
    }

    class Wheel {
        private Wheel up;
        private long noon;
        private long nextNoon;
        private final long slotDelta;
        private final TimerTask[] slots;
        private int index;

        Wheel(long time, long slotDelta, int slotCount) {
            this.slotDelta = slotDelta;
            this.slots = new TimerTask[slotCount];
            this.initArray();
            this.atNoon(time);
        }

        private void initArray() {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = new TimerTask.Sentinel();
            }
        }

        private void atNoon(long time) {
            this.index = 0;
            this.noon = time;
            this.nextNoon = time + this.slotDelta * (long)this.slots.length;
            if (this.nextNoon < 0L) {
                this.nextNoon = Long.MAX_VALUE;
            }
        }

        private void cancel() {
            this.up = null;
            this.initArray();
        }

        long executionTime(int i) {
            return this.noon + this.slotDelta * (long)i + TimerWheels.this.delta - 1L;
        }

        long nextToRun() {
            for (int i = this.index; i < this.slots.length; ++i) {
                if (!this.slots[i].isOccupied()) continue;
                return this.executionTime(i);
            }
            if (this.up == null) {
                return Long.MAX_VALUE;
            }
            long time = this.up.nextToRun();
            return time;
        }

        public TimerTask removeNextToRun(long time) {
            long hand = this.executionTime(this.index);
            if (time >= hand) {
                while (true) {
                    TimerTask head;
                    if ((head = this.slots[this.index]).isOccupied()) {
                        TimerTask t = head.next;
                        t.remove();
                        return t;
                    }
                    if (time < (hand += this.slotDelta)) break;
                    this.moveHand();
                }
            }
            return null;
        }

        private void moveHand() {
            ++this.index;
            if (this.index >= this.slots.length) {
                this.atNoon(this.nextNoon);
                this.refill();
            }
        }

        private void refill() {
            TimerTask t;
            long limit = this.nextNoon - 1L;
            Wheel up = this.up;
            if (up == null) {
                return;
            }
            while ((t = up.removeNextToRun(limit)) != null) {
                this.insert(t);
            }
        }

        private boolean schedule(TimerTask t) {
            long hand = this.executionTime(this.index - 1);
            if (t.time <= hand) {
                return false;
            }
            if (t.time < this.nextNoon) {
                this.insert(t);
                return true;
            }
            if (this.up == null) {
                this.up = new Wheel(this.nextNoon, this.slotDelta * (long)this.slots.length, this.slots.length);
            }
            return this.up.schedule(t);
        }

        private void insert(TimerTask t) {
            int idx = (int)((t.time - this.noon) / this.slotDelta);
            this.slots[idx].insert(t);
        }
    }
}

